/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.Closeable;
import java.io.File;
import java.util.function.Function;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashCode;

public class SplitClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache,
Closeable {
    private final GlobalCacheLocations globalCacheLocations;
    private final ClasspathEntrySnapshotCache globalCache;
    private final ClasspathEntrySnapshotCache localCache;

    public SplitClasspathEntrySnapshotCache(GlobalCacheLocations globalCacheLocations, ClasspathEntrySnapshotCache globalCache, ClasspathEntrySnapshotCache localCache) {
        this.globalCacheLocations = globalCacheLocations;
        this.globalCache = globalCache;
        this.localCache = localCache;
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        if (this.globalCacheLocations.isInsideGlobalCache(file.getPath())) {
            return this.globalCache.get(file, hash);
        }
        return this.localCache.get(file, hash);
    }

    @Override
    public ClasspathEntrySnapshot get(File entry, Function<? super File, ? extends ClasspathEntrySnapshot> factory) {
        return this.getCacheFor(entry).get(entry, factory);
    }

    @Override
    public ClasspathEntrySnapshot getIfPresent(File key) {
        return (ClasspathEntrySnapshot)this.getCacheFor(key).getIfPresent(key);
    }

    @Override
    public void put(File key, ClasspathEntrySnapshot value) {
        this.getCacheFor(key).put(key, value);
    }

    private ClasspathEntrySnapshotCache getCacheFor(File location) {
        if (this.globalCacheLocations.isInsideGlobalCache(location.getPath())) {
            return this.globalCache;
        }
        return this.localCache;
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.localCache).stop();
    }
}

