/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final ImmutableSetMultimap<String, String> classDependenciesFromAnnotationProcessing;
    private final ImmutableSetMultimap<String, GeneratedResource> resourceDependenciesFromAnnotationProcessing;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        ImmutableSetMultimap.Builder classDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<String>> entry : annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            for (String generated : entry.getValue()) {
                String origin = entry.getKey();
                classDependenciesFromAnnotationProcessing.put(origin, generated);
                classDependenciesFromAnnotationProcessing.put(generated, origin);
            }
        }
        this.classDependenciesFromAnnotationProcessing = classDependenciesFromAnnotationProcessing.build();
        ImmutableSetMultimap.Builder resourceDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<GeneratedResource>> entry : annotationProcessingData.getGeneratedResourcesByOrigin().entrySet()) {
            for (GeneratedResource generated : entry.getValue()) {
                String origin = entry.getKey();
                resourceDependenciesFromAnnotationProcessing.put(origin, generated);
            }
        }
        this.resourceDependenciesFromAnnotationProcessing = resourceDependenciesFromAnnotationProcessing.build();
    }

    public ClassSetAnalysis withAnnotationProcessingData(AnnotationProcessingData annotationProcessingData) {
        return new ClassSetAnalysis(this.classAnalysis, annotationProcessingData);
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet<String> accessibleResultClasses = new LinkedHashSet<String>();
        LinkedHashSet<String> privateResultClasses = new LinkedHashSet<String>();
        LinkedHashSet<GeneratedResource> resultResources = new LinkedHashSet<GeneratedResource>();
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            if (d.isEmpty()) continue;
            Set<String> accessibleDependentClasses = d.getAccessibleDependentClasses();
            Set<String> privateDependentClasses = d.getPrivateDependentClasses();
            Set<GeneratedResource> dependentResources = d.getDependentResources();
            accessibleResultClasses.addAll(accessibleDependentClasses);
            privateResultClasses.addAll(privateDependentClasses);
            resultResources.addAll(dependentResources);
        }
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        Set resourcesDependingOnAllOthers;
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(fullRebuildCause);
        }
        DependentsSet deps = this.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty()) {
            return DependentsSet.dependencyToAll();
        }
        Set<String> classesDependingOnAllOthers = this.annotationProcessingData.participatesInClassGeneration(className) ? this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers() : Collections.emptySet();
        Set<Object> set2 = resourcesDependingOnAllOthers = this.annotationProcessingData.participatesInResourceGeneration(className) ? this.annotationProcessingData.getGeneratedResourcesDependingOnAllOthers() : Collections.emptySet();
        if (!deps.hasDependentClasses() && classesDependingOnAllOthers.isEmpty() && resourcesDependingOnAllOthers.isEmpty()) {
            return deps;
        }
        HashSet<String> privateResultClasses = new HashSet<String>();
        HashSet<String> accessibleResultClasses = new HashSet<String>();
        HashSet<GeneratedResource> resultResources = new HashSet<GeneratedResource>(resourcesDependingOnAllOthers);
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, deps.getPrivateDependentClasses(), deps.getAccessibleDependentClasses());
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, Collections.emptySet(), classesDependingOnAllOthers);
        accessibleResultClasses.remove(className);
        privateResultClasses.remove(className);
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public Set<String> getTypesToReprocess() {
        return this.annotationProcessingData.getAggregatedTypes().stream().map(this.annotationProcessingData::getOriginOf).collect(Collectors.toSet());
    }

    public boolean isDependencyToAll(String className) {
        return this.classAnalysis.getDependents(className).isDependencyToAll();
    }

    private void processDependentClasses(Set<String> visitedClasses, Set<String> privateResultClasses, Set<String> accessibleResultClasses, Set<GeneratedResource> resultResources, Iterable<String> privateDependentClasses, Iterable<String> accessibleDependentClasses) {
        for (String privateDependentClass : privateDependentClasses) {
            if (!visitedClasses.add(privateDependentClass)) continue;
            privateResultClasses.add(privateDependentClass);
            DependentsSet currentDependents = this.getDependents(privateDependentClass);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
        }
        this.processTransitiveDependentClasses(visitedClasses, accessibleResultClasses, resultResources, accessibleDependentClasses);
    }

    private void processTransitiveDependentClasses(Set<String> visitedClasses, Set<String> accessibleResultClasses, Set<GeneratedResource> resultResources, Iterable<String> accessibleDependentClasses) {
        ArrayDeque<String> remainingAccessibleDependentClasses = new ArrayDeque<String>();
        for (String accessibleDependentClass : accessibleDependentClasses) {
            remainingAccessibleDependentClasses.add(accessibleDependentClass);
        }
        while (!remainingAccessibleDependentClasses.isEmpty()) {
            String accessibleDependentClass = (String)remainingAccessibleDependentClasses.pop();
            if (!visitedClasses.add(accessibleDependentClass)) continue;
            accessibleResultClasses.add(accessibleDependentClass);
            DependentsSet currentDependents = this.getDependents(accessibleDependentClass);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
            remainingAccessibleDependentClasses.addAll(currentDependents.getAccessibleDependentClasses());
        }
    }

    private DependentsSet getDependents(String className) {
        DependentsSet dependents = this.classAnalysis.getDependents(className);
        if (dependents.isDependencyToAll()) {
            return dependents;
        }
        ImmutableCollection additionalClassDeps = this.classDependenciesFromAnnotationProcessing.get((Object)className);
        ImmutableCollection additionalResourceDeps = this.resourceDependenciesFromAnnotationProcessing.get((Object)className);
        if (additionalClassDeps.isEmpty() && additionalResourceDeps.isEmpty()) {
            return dependents;
        }
        return DependentsSet.dependents(dependents.getPrivateDependentClasses(), Sets.union(dependents.getAccessibleDependentClasses(), additionalClassDeps), Sets.union(dependents.getDependentResources(), additionalResourceDeps));
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }
}

