/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResourceSerializer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class AnnotationProcessingData {
    private final Map<String, Set<String>> generatedTypesByOrigin;
    private final Map<String, String> generatedTypesToOrigin;
    private final Set<String> aggregatedTypes;
    private final Set<String> generatedTypesDependingOnAllOthers;
    private final Map<String, Set<GeneratedResource>> generatedResourcesByOrigin;
    private final Set<GeneratedResource> generatedResourcesDependingOnAllOthers;
    private final String fullRebuildCause;

    public AnnotationProcessingData() {
        this(ImmutableMap.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableMap.of(), ImmutableSet.of(), null);
    }

    public AnnotationProcessingData(Map<String, Set<String>> generatedTypesByOrigin, Set<String> aggregatedTypes, Set<String> generatedTypesDependingOnAllOthers, Map<String, Set<GeneratedResource>> generatedResourcesByOrigin, Set<GeneratedResource> generatedResourcesDependingOnAllOthers, String fullRebuildCause) {
        this.generatedTypesByOrigin = ImmutableMap.copyOf(generatedTypesByOrigin);
        this.generatedTypesToOrigin = this.buildGeneratedTypesToOrigin(generatedTypesByOrigin);
        this.aggregatedTypes = ImmutableSet.copyOf(aggregatedTypes);
        this.generatedTypesDependingOnAllOthers = ImmutableSet.copyOf(generatedTypesDependingOnAllOthers);
        this.generatedResourcesByOrigin = ImmutableMap.copyOf(generatedResourcesByOrigin);
        this.generatedResourcesDependingOnAllOthers = ImmutableSet.copyOf(generatedResourcesDependingOnAllOthers);
        this.fullRebuildCause = fullRebuildCause;
    }

    private Map<String, String> buildGeneratedTypesToOrigin(Map<String, Set<String>> generatedTypesByOrigin) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        HashSet<String> seen = Sets.newHashSet();
        for (Map.Entry<String, Set<String>> entry : generatedTypesByOrigin.entrySet()) {
            String origin = entry.getKey();
            for (String generatedType : entry.getValue()) {
                if (!seen.add(generatedType)) continue;
                builder.put(generatedType, origin);
            }
        }
        return builder.build();
    }

    public boolean participatesInClassGeneration(String clazzName) {
        return this.aggregatedTypes.contains(clazzName) || this.generatedTypesByOrigin.containsKey(clazzName);
    }

    public boolean participatesInResourceGeneration(String clazzName) {
        return this.participatesInClassGeneration(clazzName) || this.generatedResourcesByOrigin.containsKey(clazzName);
    }

    public Map<String, Set<String>> getGeneratedTypesByOrigin() {
        return this.generatedTypesByOrigin;
    }

    public Set<String> getAggregatedTypes() {
        return this.aggregatedTypes;
    }

    public Set<String> getGeneratedTypesDependingOnAllOthers() {
        return this.generatedTypesDependingOnAllOthers;
    }

    public Map<String, Set<GeneratedResource>> getGeneratedResourcesByOrigin() {
        return this.generatedResourcesByOrigin;
    }

    public Set<GeneratedResource> getGeneratedResourcesDependingOnAllOthers() {
        return this.generatedResourcesDependingOnAllOthers;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public String getOriginOf(String type) {
        return this.generatedTypesToOrigin.getOrDefault(type, type);
    }

    public static final class Serializer
    extends AbstractSerializer<AnnotationProcessingData> {
        private final SetSerializer<String> typesSerializer;
        private final MapSerializer<String, Set<String>> generatedTypesSerializer;
        private final SetSerializer<GeneratedResource> resourcesSerializer;
        private final MapSerializer<String, Set<GeneratedResource>> generatedResourcesSerializer;

        public Serializer(StringInterner interner) {
            InterningStringSerializer stringSerializer = new InterningStringSerializer(interner);
            this.typesSerializer = new SetSerializer<String>(stringSerializer);
            this.generatedTypesSerializer = new MapSerializer<String, String>(stringSerializer, this.typesSerializer);
            GeneratedResourceSerializer resourceSerializer = new GeneratedResourceSerializer(stringSerializer);
            this.resourcesSerializer = new SetSerializer<GeneratedResource>(resourceSerializer);
            this.generatedResourcesSerializer = new MapSerializer<String, GeneratedResource>(stringSerializer, this.resourcesSerializer);
        }

        @Override
        public AnnotationProcessingData read(Decoder decoder) throws Exception {
            Object generatedTypes = this.generatedTypesSerializer.read(decoder);
            Set aggregatedTypes = (Set)this.typesSerializer.read(decoder);
            Set generatedTypesDependingOnAllOthers = (Set)this.typesSerializer.read(decoder);
            String fullRebuildCause = decoder.readNullableString();
            Object generatedResources = this.generatedResourcesSerializer.read(decoder);
            Set generatedResourcesDependingOnAllOthers = (Set)this.resourcesSerializer.read(decoder);
            return new AnnotationProcessingData((Map<String, Set<String>>)generatedTypes, aggregatedTypes, generatedTypesDependingOnAllOthers, (Map<String, Set<GeneratedResource>>)generatedResources, generatedResourcesDependingOnAllOthers, fullRebuildCause);
        }

        @Override
        public void write(Encoder encoder, AnnotationProcessingData value) throws Exception {
            this.generatedTypesSerializer.write(encoder, value.generatedTypesByOrigin);
            this.typesSerializer.write(encoder, value.aggregatedTypes);
            this.typesSerializer.write(encoder, value.generatedTypesDependingOnAllOthers);
            encoder.writeNullableString(value.fullRebuildCause);
            this.generatedResourcesSerializer.write(encoder, value.generatedResourcesByOrigin);
            this.resourcesSerializer.write(encoder, value.generatedResourcesDependingOnAllOthers);
        }
    }
}

