/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;

public class DefaultSourceFileClassNameConverter
implements SourceFileClassNameConverter {
    private final Multimap<String, String> sourceClassesMapping;
    private final Map<String, String> classSourceMapping;

    public DefaultSourceFileClassNameConverter(Multimap<String, String> sourceClassesMapping) {
        this.sourceClassesMapping = sourceClassesMapping;
        this.classSourceMapping = this.constructReverseMapping(sourceClassesMapping);
    }

    private Map<String, String> constructReverseMapping(Multimap<String, String> sourceClassesMapping) {
        return sourceClassesMapping.entries().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    @Override
    public Collection<String> getClassNames(String sourceFileRelativePath) {
        return this.sourceClassesMapping.get(sourceFileRelativePath);
    }

    @Override
    public boolean isEmpty() {
        return this.classSourceMapping.isEmpty();
    }

    @Override
    public Optional<String> getRelativeSourcePath(String fqcn) {
        return Optional.ofNullable(this.classSourceMapping.get(fqcn));
    }
}

