/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.properties.CacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.work.DisableCachingByDefault;

public class DefaultTaskCacheabilityResolver
implements TaskCacheabilityResolver {
    private static final CachingDisabledReason CACHING_NOT_ENABLED = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching has not been enabled for the task");
    private static final CachingDisabledReason CACHING_DISABLED = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching has been disabled for the task");
    private static final CachingDisabledReason NO_OUTPUTS_DECLARED = new CachingDisabledReason(CachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final RelativeFilePathResolver relativeFilePathResolver;

    public DefaultTaskCacheabilityResolver(RelativeFilePathResolver relativeFilePathResolver) {
        this.relativeFilePathResolver = relativeFilePathResolver;
    }

    @Override
    public Optional<CachingDisabledReason> shouldDisableCaching(boolean hasDeclaredOutputs, ImmutableSortedSet<OutputFilePropertySpec> outputFileProperties, TaskInternal task, Collection<SelfDescribingSpec<TaskInternal>> cacheIfSpecs, Collection<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs, @Nullable OverlappingOutputs overlappingOutputs) {
        if (cacheIfSpecs.isEmpty()) {
            if (task.getClass().isAnnotationPresent(DisableCachingByDefault.class)) {
                DisableCachingByDefault doNotCacheAnnotation = task.getClass().getAnnotation(DisableCachingByDefault.class);
                String reason = doNotCacheAnnotation.because();
                if (reason.isEmpty()) {
                    return Optional.of(CACHING_DISABLED);
                }
                return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, reason));
            }
            return Optional.of(CACHING_NOT_ENABLED);
        }
        if (!hasDeclaredOutputs) {
            return Optional.of(NO_OUTPUTS_DECLARED);
        }
        if (overlappingOutputs != null) {
            String relativePath = this.relativeFilePathResolver.resolveForDisplay(overlappingOutputs.getOverlappedFilePath());
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, "Gradle does not know how file '" + relativePath + "' was created (output property '" + overlappingOutputs.getPropertyName() + "'). Task output caching requires exclusive access to output paths to guarantee correctness (i.e. multiple tasks are not allowed to produce output in the same location)."));
        }
        for (OutputFilePropertySpec spec : outputFileProperties) {
            if (spec instanceof CacheableOutputFilePropertySpec) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.NON_CACHEABLE_OUTPUT, "Output property '" + spec.getPropertyName() + "' contains a file tree"));
        }
        for (SelfDescribingSpec<TaskInternal> cacheIfSpec : cacheIfSpecs) {
            if (cacheIfSpec.isSatisfiedBy(task)) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.ENABLE_CONDITION_NOT_SATISFIED, "'" + cacheIfSpec.getDisplayName() + "' not satisfied"));
        }
        for (SelfDescribingSpec<TaskInternal> doNotCacheIfSpec : doNotCacheIfSpecs) {
            if (!doNotCacheIfSpec.isSatisfiedBy(task)) continue;
            return Optional.of(new CachingDisabledReason(CachingDisabledReasonCategory.DISABLE_CONDITION_SATISFIED, "'" + doNotCacheIfSpec.getDisplayName() + "' satisfied"));
        }
        return Optional.empty();
    }
}

