/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.work.Incremental;

public enum ModifierAnnotationCategory implements AnnotationCategory
{
    INCREMENTAL(ImmutableSet.of(Incremental.class, SkipWhenEmpty.class)),
    NORMALIZATION(ImmutableSet.of(Classpath.class, CompileClasspath.class, PathSensitive.class)),
    OPTIONAL(ImmutableSet.of(Optional.class)),
    IGNORE_EMPTY_DIRECTORIES(ImmutableSet.of(IgnoreEmptyDirectories.class));

    private final ImmutableSet<Class<? extends Annotation>> annotations;

    private ModifierAnnotationCategory(ImmutableSet<Class<? extends Annotation>> annotations) {
        this.annotations = annotations;
    }

    @Override
    public String getDisplayName() {
        return this.name().toLowerCase();
    }

    public static Map<Class<? extends Annotation>, AnnotationCategory> asMap(Collection<Class<? extends Annotation>> typeAnnotations) {
        ImmutableMap.Builder<Class, AnnotationCategory> builder = ImmutableMap.builder();
        for (Class<? extends Annotation> typeAnnotation : typeAnnotations) {
            builder.put(typeAnnotation, TYPE);
        }
        for (ModifierAnnotationCategory category : ModifierAnnotationCategory.values()) {
            for (Class clazz : category.annotations) {
                builder.put(clazz, category);
            }
        }
        return builder.build();
    }
}

