/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class RuntimeBeanNode<T>
extends AbstractPropertyNode<Object> {
    private final T bean;

    protected RuntimeBeanNode(@Nullable RuntimeBeanNode<?> parentNode, @Nullable String propertyName, T bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, typeMetadata);
        this.bean = Preconditions.checkNotNull(bean, "Null is not allowed as nested property '%s'", (Object)propertyName);
    }

    public T getBean() {
        return this.bean;
    }

    @Override
    protected Object getNodeValue() {
        return this.getBean();
    }

    public abstract void visitNode(PropertyVisitor var1, Queue<RuntimeBeanNode<?>> var2, RuntimeBeanNodeFactory var3, TypeValidationContext var4);

    public RuntimeBeanNode<?> createChildNode(String propertyName, @Nullable Object input, RuntimeBeanNodeFactory nodeFactory) {
        String qualifiedPropertyName = this.getQualifiedPropertyName(propertyName);
        Object bean = Preconditions.checkNotNull(input, "Null is not allowed as nested property '%s'", (Object)qualifiedPropertyName);
        return nodeFactory.create(this, qualifiedPropertyName, bean);
    }

    public void checkCycles(String propertyName, Object childBean) {
        AbstractPropertyNode<Object> nodeCreatingCycle = this.findNodeCreatingCycle(childBean, Equivalence.identity());
        Preconditions.checkState(nodeCreatingCycle == null, "Cycles between nested beans are not allowed. Cycle detected between: '%s' and '%s'.", nodeCreatingCycle, (Object)propertyName);
    }
}

