/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.temp.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.testing.detection.JarFilePackageListener;
import org.gradle.api.internal.tasks.testing.detection.JarFilePackageLister;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.org.apache.commons.lang.text.StrBuilder;
import org.gradle.util.JarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFileExtractionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileExtractionManager.class);
    private final Map<String, Set<File>> packageJarFilesMappings;
    private final Map<String, File> extractedJarClasses;
    private final Set<String> unextractableClasses;
    private final TemporaryFileProvider tempDirProvider;

    public ClassFileExtractionManager(Factory<File> tempDirFactory) {
        assert (tempDirFactory != null);
        this.tempDirProvider = new DefaultTemporaryFileProvider(tempDirFactory);
        this.packageJarFilesMappings = new HashMap<String, Set<File>>();
        this.extractedJarClasses = new HashMap<String, File>();
        this.unextractableClasses = new TreeSet<String>();
    }

    public void addLibraryJar(final File libraryJar) {
        new JarFilePackageLister().listJarPackages(libraryJar, new JarFilePackageListener(){

            @Override
            public void receivePackage(String packageName) {
                TreeSet<File> jarFiles = (TreeSet<File>)ClassFileExtractionManager.this.packageJarFilesMappings.get(packageName);
                if (jarFiles == null) {
                    jarFiles = new TreeSet<File>();
                }
                jarFiles.add(libraryJar);
                ClassFileExtractionManager.this.packageJarFilesMappings.put(packageName, jarFiles);
            }
        });
    }

    public File getLibraryClassFile(String className) {
        if (this.unextractableClasses.contains(className)) {
            return null;
        }
        if (!this.extractedJarClasses.containsKey(className) && !this.extractClassFile(className)) {
            this.unextractableClasses.add(className);
        }
        return this.extractedJarClasses.get(className);
    }

    private boolean extractClassFile(String className) {
        boolean classFileExtracted = false;
        File extractedClassFile = this.tempFile();
        String classFileName = new StrBuilder().append(className).append(".class").toString();
        String classNamePackage = this.classNamePackage(className);
        Set<File> packageJarFiles = this.packageJarFilesMappings.get(classNamePackage);
        File classFileSourceJar = null;
        if (packageJarFiles != null && !packageJarFiles.isEmpty()) {
            Iterator<File> packageJarFilesIt = packageJarFiles.iterator();
            while (!classFileExtracted && packageJarFilesIt.hasNext()) {
                File jarFile = packageJarFilesIt.next();
                try {
                    classFileExtracted = JarUtil.extractZipEntry(jarFile, classFileName, extractedClassFile);
                    if (!classFileExtracted) continue;
                    classFileSourceJar = jarFile;
                }
                catch (IOException e) {
                    throw new GradleException("failed to extract class file from jar (" + jarFile + ")", e);
                }
            }
            if (classFileExtracted) {
                LOGGER.debug("extracted class {} from {}", (Object)className, (Object)classFileSourceJar.getName());
                this.extractedJarClasses.put(className, extractedClassFile);
            }
        }
        return classFileExtracted;
    }

    private String classNamePackage(String className) {
        int lastSlashIndex = className.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return null;
        }
        return className.substring(0, lastSlashIndex + 1);
    }

    private File tempFile() {
        return this.tempDirProvider.createTemporaryFile("jar_extract_", "_tmp", new String[0]);
    }
}

