/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import java.util.List;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestClassScanner;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.PatternMatchTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RunPreviousFailedFirstTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestClassProcessor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class DefaultTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private static final Logger LOGGER = Logging.getLogger(DefaultTestExecuter.class);
    private final WorkerProcessFactory workerFactory;
    private final ActorFactory actorFactory;
    private final ModuleRegistry moduleRegistry;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final int maxWorkerCount;
    private final Clock clock;
    private final DocumentationRegistry documentationRegistry;
    private final DefaultTestFilter testFilter;
    private TestClassProcessor processor;

    public DefaultTestExecuter(WorkerProcessFactory workerFactory, ActorFactory actorFactory, ModuleRegistry moduleRegistry, WorkerLeaseRegistry workerLeaseRegistry, int maxWorkerCount, Clock clock, DocumentationRegistry documentationRegistry, DefaultTestFilter testFilter) {
        this.workerFactory = workerFactory;
        this.actorFactory = actorFactory;
        this.moduleRegistry = moduleRegistry;
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.maxWorkerCount = maxWorkerCount;
        this.clock = clock;
        this.documentationRegistry = documentationRegistry;
        this.testFilter = testFilter;
    }

    @Override
    public void execute(final JvmTestExecutionSpec testExecutionSpec, TestResultProcessor testResultProcessor) {
        DefaultTestClassScanner detector;
        final TestFramework testFramework = testExecutionSpec.getTestFramework();
        final WorkerTestClassProcessorFactory testInstanceFactory = testFramework.getProcessorFactory();
        final WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseRegistry.getCurrentWorkerLease();
        final ImmutableSet<File> classpath = ImmutableSet.copyOf(testExecutionSpec.getClasspath());
        final ImmutableSet<? extends File> modulePath = ImmutableSet.copyOf(testExecutionSpec.getModulePath());
        final List<String> testWorkerImplementationModules = testFramework.getTestWorkerImplementationModules();
        final Factory<TestClassProcessor> forkingProcessorFactory = new Factory<TestClassProcessor>(){

            @Override
            public TestClassProcessor create() {
                return new ForkingTestClassProcessor(currentWorkerLease, DefaultTestExecuter.this.workerFactory, testInstanceFactory, testExecutionSpec.getJavaForkOptions(), classpath, modulePath, testWorkerImplementationModules, testFramework.getWorkerConfigurationAction(), DefaultTestExecuter.this.moduleRegistry, DefaultTestExecuter.this.documentationRegistry);
            }
        };
        Factory<TestClassProcessor> reforkingProcessorFactory = new Factory<TestClassProcessor>(){

            @Override
            public TestClassProcessor create() {
                return new RestartEveryNTestClassProcessor(forkingProcessorFactory, testExecutionSpec.getForkEvery());
            }
        };
        this.processor = new PatternMatchTestClassProcessor(this.testFilter, new RunPreviousFailedFirstTestClassProcessor(testExecutionSpec.getPreviousFailedTestClasses(), new MaxNParallelTestClassProcessor(this.getMaxParallelForks(testExecutionSpec), reforkingProcessorFactory, this.actorFactory)));
        FileTree testClassFiles = testExecutionSpec.getCandidateClassFiles();
        if (testExecutionSpec.isScanForTestClasses() && testFramework.getDetector() != null) {
            TestFrameworkDetector testFrameworkDetector = testFramework.getDetector();
            testFrameworkDetector.setTestClasses(testExecutionSpec.getTestClassesDirs().getFiles());
            testFrameworkDetector.setTestClasspath(classpath);
            detector = new DefaultTestClassScanner(testClassFiles, testFrameworkDetector, this.processor);
        } else {
            detector = new DefaultTestClassScanner(testClassFiles, null, this.processor);
        }
        new TestMainAction(detector, this.processor, testResultProcessor, this.clock, testExecutionSpec.getPath(), "Gradle Test Run " + testExecutionSpec.getIdentityPath()).run();
    }

    @Override
    public void stopNow() {
        if (this.processor != null) {
            this.processor.stopNow();
        }
    }

    private int getMaxParallelForks(JvmTestExecutionSpec testExecutionSpec) {
        int maxParallelForks = testExecutionSpec.getMaxParallelForks();
        if (maxParallelForks > this.maxWorkerCount) {
            LOGGER.info("{}.maxParallelForks ({}) is larger than max-workers ({}), forcing it to {}", testExecutionSpec.getPath(), maxParallelForks, this.maxWorkerCount, this.maxWorkerCount);
            maxParallelForks = this.maxWorkerCount;
        }
        return maxParallelForks;
    }
}

