/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.internal.impldep.com.google.common.base.CharMatcher;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.BooleanUtils;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.time.Clock;
import org.gradle.util.TextUtil;

public class DefaultUserInputHandler
implements UserInputHandler {
    private static final List<String> YES_NO_CHOICES = Lists.newArrayList("yes", "no");
    private final OutputEventListener outputEventBroadcaster;
    private final Clock clock;
    private final UserInputReader userInputReader;
    private final AtomicBoolean hasAsked = new AtomicBoolean();

    public DefaultUserInputHandler(OutputEventListener outputEventBroadcaster, Clock clock, UserInputReader userInputReader) {
        this.outputEventBroadcaster = outputEventBroadcaster;
        this.clock = clock;
        this.userInputReader = userInputReader;
    }

    @Override
    public Boolean askYesNoQuestion(String question) {
        StringBuilder builder = new StringBuilder();
        builder.append(question);
        builder.append(" [");
        builder.append(StringUtils.join(YES_NO_CHOICES, ", "));
        builder.append("] ");
        return this.prompt(builder.toString(), new BooleanParser());
    }

    @Override
    public boolean askYesNoQuestion(String question, boolean defaultValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(question);
        builder.append(" (default: ");
        builder.append(defaultValue ? "yes" : "no");
        builder.append(") [");
        builder.append(StringUtils.join(YES_NO_CHOICES, ", "));
        builder.append("] ");
        return this.prompt(builder.toString(), defaultValue, new BooleanParser());
    }

    @Override
    public <T> T selectOption(String question, final Collection<T> options, T defaultOption) {
        final ArrayList<T> values = new ArrayList<T>(options);
        StringBuilder builder = new StringBuilder();
        builder.append(question);
        builder.append(":");
        builder.append(TextUtil.getPlatformLineSeparator());
        for (int i = 0; i < options.size(); ++i) {
            Object option = values.get(i);
            builder.append("  ");
            builder.append(i + 1);
            builder.append(": ");
            builder.append(option);
            builder.append(TextUtil.getPlatformLineSeparator());
        }
        builder.append("Enter selection (default: ");
        builder.append(defaultOption);
        builder.append(") [1..");
        builder.append(options.size());
        builder.append("] ");
        return this.prompt(builder.toString(), defaultOption, new Transformer<T, String>(){

            @Override
            public T transform(String sanitizedInput) {
                int value;
                if (sanitizedInput.matches("\\d+") && (value = Integer.parseInt(sanitizedInput)) > 0 && value <= values.size()) {
                    return values.get(value - 1);
                }
                DefaultUserInputHandler.this.sendPrompt("Please enter a value between 1 and " + options.size() + ": ");
                return null;
            }
        });
    }

    @Override
    public String askQuestion(String question, String defaultValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(question);
        builder.append(" (default: ");
        builder.append(defaultValue);
        builder.append("): ");
        return this.prompt(builder.toString(), defaultValue, new Transformer<String, String>(){

            @Override
            public String transform(String sanitizedValue) {
                return sanitizedValue;
            }
        });
    }

    private <T> T prompt(String prompt, final T defaultValue, final Transformer<T, String> parser) {
        T result = this.prompt(prompt, new Transformer<T, String>(){

            @Override
            public T transform(String sanitizedInput) {
                if (sanitizedInput.isEmpty()) {
                    return defaultValue;
                }
                return parser.transform(sanitizedInput);
            }
        });
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Nullable
    private <T> T prompt(String prompt, Transformer<T, String> parser) {
        this.outputEventBroadcaster.onOutput(new UserInputRequestEvent());
        try {
            if (this.hasAsked.compareAndSet(false, true)) {
                this.sendPrompt(TextUtil.getPlatformLineSeparator());
            }
            this.sendPrompt(prompt);
            while (true) {
                String input;
                if ((input = this.userInputReader.readInput()) == null) {
                    T t = null;
                    return t;
                }
                String sanitizedInput = this.sanitizeInput(input);
                T result = parser.transform(sanitizedInput);
                if (result == null) continue;
                T t = result;
                return t;
            }
        }
        finally {
            this.sendPrompt(TextUtil.getPlatformLineSeparator());
            this.outputEventBroadcaster.onOutput(new UserInputResumeEvent());
        }
    }

    private void sendPrompt(String prompt) {
        this.outputEventBroadcaster.onOutput(new PromptOutputEvent(this.clock.getCurrentTime(), prompt));
    }

    private String sanitizeInput(String input) {
        return CharMatcher.javaIsoControl().removeFrom(StringUtils.trim(input));
    }

    private class BooleanParser
    implements Transformer<Boolean, String> {
        private BooleanParser() {
        }

        @Override
        public Boolean transform(String value) {
            if (YES_NO_CHOICES.contains(value)) {
                return BooleanUtils.toBoolean(value);
            }
            DefaultUserInputHandler.this.sendPrompt("Please enter 'yes' or 'no': ");
            return null;
        }
    }
}

