/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.jvm.internal.JvmModelingServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectTestFixtures;

public class JavaTestFixturesPlugin
implements Plugin<Project> {
    private final JvmModelingServices jvmEcosystemUtilities;

    @Inject
    public JavaTestFixturesPlugin(JvmModelingServices jvmModelingServices) {
        this.jvmEcosystemUtilities = jvmModelingServices;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            this.jvmEcosystemUtilities.createJvmVariant("testFixtures", builder -> builder.exposesApi().published());
            this.createImplicitTestFixturesDependencies(project, this.findJavaConvention(project));
        });
    }

    private void createImplicitTestFixturesDependencies(Project project, JavaPluginConvention convention) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("testFixturesApi", dependencies.create(project));
        SourceSet testSourceSet = this.findTestSourceSet(convention);
        ProjectDependency testDependency = (ProjectDependency)dependencies.add(testSourceSet.getImplementationConfigurationName(), dependencies.create(project));
        testDependency.capabilities(new ProjectTestFixtures(project));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath(project.getObjects().fileCollection().from(configurations.getByName("testCompileClasspath")));
        testSourceSet.setRuntimeClasspath(project.getObjects().fileCollection().from(testSourceSet.getOutput(), configurations.getByName("testRuntimeClasspath")));
    }

    private SourceSet findTestSourceSet(JavaPluginConvention convention) {
        return (SourceSet)convention.getSourceSets().getByName("test");
    }

    private JavaPluginConvention findJavaConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugins().get("java");
    }
}

