/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.Actions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.ToolchainSpecInternal;
import org.gradle.util.ConfigureUtil;

public class DefaultJavaPluginConvention
extends JavaPluginConvention
implements HasPublicType {
    private ProjectInternal project;
    private String docsDirName;
    private String testResultsDirName;
    private String testReportDirName;
    private final SourceSetContainer sourceSets;
    private JavaVersion srcCompat;
    private JavaVersion targetCompat;
    private boolean autoTargetJvm = true;
    private final ToolchainSpecInternal toolchainSpec;

    public DefaultJavaPluginConvention(ProjectInternal project, SourceSetContainer sourceSets, DefaultToolchainSpec toolchainSpec) {
        this.project = project;
        this.sourceSets = sourceSets;
        this.toolchainSpec = toolchainSpec;
        this.docsDirName = "docs";
        this.testResultsDirName = "test-results";
        this.testReportDirName = "tests";
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaPluginConvention.class);
    }

    @Override
    public Object sourceSets(Closure closure) {
        return this.sourceSets.configure(closure);
    }

    @Override
    public File getDocsDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.project.getBuildDir()).resolve(this.docsDirName);
    }

    @Override
    public File getTestResultsDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.project.getBuildDir()).resolve(this.testResultsDirName);
    }

    @Override
    public File getTestReportDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.getReportsDir()).resolve(this.testReportDirName);
    }

    private File getReportsDir() {
        return this.project.getExtensions().getByType(ReportingExtension.class).getBaseDir();
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        if (this.srcCompat != null) {
            return this.srcCompat;
        }
        if (this.toolchainSpec != null && this.toolchainSpec.isConfigured()) {
            return JavaVersion.toVersion(((JavaLanguageVersion)this.toolchainSpec.getLanguageVersion().get()).toString());
        }
        return JavaVersion.current();
    }

    public JavaVersion getRawSourceCompatibility() {
        return this.srcCompat;
    }

    @Override
    public void setSourceCompatibility(Object value) {
        this.setSourceCompatibility(JavaVersion.toVersion(value));
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.srcCompat = value;
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.targetCompat != null ? this.targetCompat : this.getSourceCompatibility();
    }

    public JavaVersion getRawTargetCompatibility() {
        return this.targetCompat;
    }

    @Override
    public void setTargetCompatibility(Object value) {
        this.setTargetCompatibility(JavaVersion.toVersion(value));
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.targetCompat = value;
    }

    @Override
    public Manifest manifest() {
        return this.manifest(Actions.doNothing());
    }

    @Override
    public Manifest manifest(Closure closure) {
        return ConfigureUtil.configure(closure, this.createManifest());
    }

    @Override
    public Manifest manifest(Action<? super Manifest> action) {
        Manifest manifest = this.createManifest();
        action.execute(manifest);
        return manifest;
    }

    private Manifest createManifest() {
        return new DefaultManifest(this.project.getFileResolver());
    }

    @Override
    public String getDocsDirName() {
        return this.docsDirName;
    }

    @Override
    public void setDocsDirName(String docsDirName) {
        this.docsDirName = docsDirName;
    }

    @Override
    public String getTestResultsDirName() {
        return this.testResultsDirName;
    }

    @Override
    public void setTestResultsDirName(String testResultsDirName) {
        this.testResultsDirName = testResultsDirName;
    }

    @Override
    public String getTestReportDirName() {
        return this.testReportDirName;
    }

    @Override
    public void setTestReportDirName(String testReportDirName) {
        this.testReportDirName = testReportDirName;
    }

    @Override
    public SourceSetContainer getSourceSets() {
        return this.sourceSets;
    }

    @Override
    public ProjectInternal getProject() {
        return this.project;
    }

    @Override
    public void disableAutoTargetJvm() {
        this.autoTargetJvm = false;
    }

    @Override
    public boolean getAutoTargetJvmDisabled() {
        return !this.autoTargetJvm;
    }
}

