/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;

public class CheckstylePlugin
extends AbstractCodeQualityPlugin<Checkstyle> {
    public static final String DEFAULT_CHECKSTYLE_VERSION = "8.37";
    private static final String CONFIG_DIR_NAME = "config/checkstyle";
    private CheckstyleExtension extension;

    @Override
    protected String getToolName() {
        return "Checkstyle";
    }

    @Override
    protected Class<Checkstyle> getTaskType() {
        return Checkstyle.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("checkstyle", CheckstyleExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_CHECKSTYLE_VERSION);
        Directory directory = this.project.getRootProject().getLayout().getProjectDirectory().dir(CONFIG_DIR_NAME);
        this.extension.getConfigDirectory().convention(this.project.provider(() -> {
            if (directory.getAsFile().exists()) {
                return directory;
            }
            return null;
        }));
        this.extension.setConfig(this.project.getResources().getText().fromFile(this.extension.getConfigDirectory().file("checkstyle.xml").orElse(directory.file("checkstyle.xml"))));
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Checkstyle task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add(this.project.getDependencies().create("com.puppycrawl.tools:checkstyle:" + this.extension.getToolVersion())));
    }

    private void configureTaskConventionMapping(Configuration configuration, Checkstyle task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("checkstyleClasspath", Callables.returning(configuration));
        taskMapping.map("config", () -> this.extension.getConfig());
        taskMapping.map("configProperties", () -> this.extension.getConfigProperties());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
        taskMapping.map("showViolations", () -> this.extension.isShowViolations());
        taskMapping.map("maxErrors", () -> this.extension.getMaxErrors());
        taskMapping.map("maxWarnings", () -> this.extension.getMaxWarnings());
        task.getConfigDirectory().convention((Provider)this.extension.getConfigDirectory());
    }

    private void configureReportsConventionMapping(Checkstyle task, String baseName) {
        ProjectLayout layout = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider<RegularFile> reportsDir = layout.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action(report -> {
            report.getRequired().convention(true);
            report.getOutputLocation().convention(layout.getProjectDirectory().file(providers.provider(() -> {
                String reportFileName = baseName + "." + report.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), reportFileName).getAbsolutePath();
            })));
        }));
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Checkstyle task) {
        task.setDescription("Run Checkstyle analysis for " + sourceSet.getName() + " classes");
        task.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
        task.setSource(sourceSet.getAllJava());
    }
}

