/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class CodeNarcExtension
extends CodeQualityExtension {
    private static final Set<String> REPORT_FORMATS = Sets.newHashSet("xml", "html", "console", "text");
    private final Project project;
    private TextResource config;
    private int maxPriority1Violations;
    private int maxPriority2Violations;
    private int maxPriority3Violations;
    private String reportFormat;

    public CodeNarcExtension(Project project) {
        this.project = project;
    }

    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    public File getConfigFile() {
        return this.getConfig().asFile();
    }

    public void setConfigFile(File file) {
        this.setConfig(this.project.getResources().getText().fromFile(file));
    }

    public int getMaxPriority1Violations() {
        return this.maxPriority1Violations;
    }

    public void setMaxPriority1Violations(int maxPriority1Violations) {
        this.maxPriority1Violations = maxPriority1Violations;
    }

    public int getMaxPriority2Violations() {
        return this.maxPriority2Violations;
    }

    public void setMaxPriority2Violations(int maxPriority2Violations) {
        this.maxPriority2Violations = maxPriority2Violations;
    }

    public int getMaxPriority3Violations() {
        return this.maxPriority3Violations;
    }

    public void setMaxPriority3Violations(int maxPriority3Violations) {
        this.maxPriority3Violations = maxPriority3Violations;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        if (!REPORT_FORMATS.contains(reportFormat)) {
            throw new InvalidUserDataException("'" + reportFormat + "' is not a valid codenarc report format");
        }
        this.reportFormat = reportFormat;
    }
}

