/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.DefaultVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publication.WritableMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;

public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final InstantiatorFactory instantiatorFactory;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ProviderFactory providerFactory;

    @Inject
    public MavenPublishPlugin(InstantiatorFactory instantiatorFactory, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ImmutableAttributesFactory immutableAttributesFactory, ProviderFactory providerFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.providerFactory = providerFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        tasks.register(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME, publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
            publish.setGroup("publishing");
        });
        project.getExtensions().configure(PublishingExtension.class, extension -> {
            extension.getPublications().registerFactory(MavenPublication.class, new MavenPublicationFactory(this.dependencyMetaDataProvider, this.instantiatorFactory.decorateLenient(), this.fileResolver, project.getPluginManager(), project.getExtensions()));
            this.realizePublishingTasksLater(project, (PublishingExtension)extension);
        });
    }

    private void realizePublishingTasksLater(Project project, PublishingExtension extension) {
        NamedDomainObjectCollection mavenPublications = extension.getPublications().withType(MavenPublicationInternal.class);
        TaskContainer tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        NamedDomainObjectProvider publishLifecycleTask = tasks.named("publish");
        NamedDomainObjectProvider publishLocalLifecycleTask = tasks.named(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        NamedDomainObjectCollection repositories = extension.getRepositories().withType(MavenArtifactRepository.class);
        repositories.all(repository -> tasks.register(this.publishAllToSingleRepoTaskName((MavenArtifactRepository)repository), publish -> {
            publish.setDescription("Publishes all Maven publications produced by this project to the " + repository.getName() + " repository.");
            publish.setGroup("publishing");
        }));
        mavenPublications.all(arg_0 -> this.lambda$realizePublishingTasksLater$4(tasks, (NamedDomainObjectSet)mavenPublications, buildDirectory, project, (TaskProvider)publishLocalLifecycleTask, (TaskProvider)publishLifecycleTask, (NamedDomainObjectList)repositories, arg_0));
    }

    private String publishAllToSingleRepoTaskName(MavenArtifactRepository repository) {
        return "publishAllPublicationsTo" + StringUtils.capitalize(repository.getName()) + "Repository";
    }

    private void createPublishTasksForEachMavenRepo(TaskContainer tasks, TaskProvider<Task> publishLifecycleTask, MavenPublicationInternal publication, NamedDomainObjectList<MavenArtifactRepository> repositories) {
        String publicationName = publication.getName();
        repositories.all(repository -> {
            String repositoryName = repository.getName();
            String publishTaskName = "publish" + StringUtils.capitalize(publicationName) + "PublicationTo" + StringUtils.capitalize(repositoryName) + "Repository";
            tasks.register(publishTaskName, PublishToMavenRepository.class, publishTask -> {
                publishTask.setPublication(publication);
                publishTask.setRepository((MavenArtifactRepository)repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription("Publishes Maven publication '" + publicationName + "' to Maven repository '" + repositoryName + "'.");
            });
            publishLifecycleTask.configure(task -> task.dependsOn(publishTaskName));
            tasks.named(this.publishAllToSingleRepoTaskName((MavenArtifactRepository)repository), publish -> publish.dependsOn(publishTaskName));
        });
    }

    private void createLocalInstallTask(TaskContainer tasks, TaskProvider<Task> publishLocalLifecycleTask, MavenPublicationInternal publication) {
        String publicationName = publication.getName();
        String installTaskName = "publish" + StringUtils.capitalize(publicationName) + "PublicationToMavenLocal";
        tasks.register(installTaskName, PublishToMavenLocal.class, publishLocalTask -> {
            publishLocalTask.setPublication(publication);
            publishLocalTask.setGroup("publishing");
            publishLocalTask.setDescription("Publishes Maven publication '" + publicationName + "' to the local Maven repository.");
        });
        publishLocalLifecycleTask.configure(task -> task.dependsOn(installTaskName));
    }

    private void createGeneratePomTask(TaskContainer tasks, MavenPublicationInternal publication, DirectoryProperty buildDir, Project project) {
        String publicationName = publication.getName();
        String descriptorTaskName = "generatePomFileFor" + StringUtils.capitalize(publicationName) + "Publication";
        NamedDomainObjectProvider generatorTask = tasks.register(descriptorTaskName, GenerateMavenPom.class, generatePomTask -> {
            generatePomTask.setDescription("Generates the Maven POM file for publication '" + publicationName + "'.");
            generatePomTask.setGroup("publishing");
            generatePomTask.setPom(publication.getPom());
            if (generatePomTask.getDestination() == null) {
                generatePomTask.setDestination(buildDir.file("publications/" + publication.getName() + "/pom-default.xml"));
            }
            project.getPluginManager().withPlugin("org.gradle.java", plugin -> generatePomTask.withCompileScopeAttributes(this.immutableAttributesFactory.of(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api"))).withRuntimeScopeAttributes(this.immutableAttributesFactory.of(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"))));
        });
        publication.setPomGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private void createGenerateMetadataTask(TaskContainer tasks, MavenPublicationInternal publication, Set<? extends MavenPublicationInternal> publications, DirectoryProperty buildDir) {
        String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize(publicationName) + "Publication";
        NamedDomainObjectProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, generateTask -> {
            generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
            generateTask.setGroup("publishing");
            generateTask.getPublication().set(publication);
            generateTask.getPublications().set(publications);
            generateTask.getOutputFile().convention(buildDir.file("publications/" + publication.getName() + "/module.json"));
        });
        publication.setModuleDescriptorGenerator((TaskProvider<? extends Task>)generatorTask);
    }

    private /* synthetic */ void lambda$realizePublishingTasksLater$4(TaskContainer tasks, NamedDomainObjectSet mavenPublications, DirectoryProperty buildDirectory, Project project, TaskProvider publishLocalLifecycleTask, TaskProvider publishLifecycleTask, NamedDomainObjectList repositories, MavenPublicationInternal publication) {
        this.createGenerateMetadataTask(tasks, publication, mavenPublications, buildDirectory);
        this.createGeneratePomTask(tasks, publication, buildDirectory, project);
        this.createLocalInstallTask(tasks, publishLocalLifecycleTask, publication);
        this.createPublishTasksForEachMavenRepo(tasks, publishLifecycleTask, publication, repositories);
    }

    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;
        private final PluginManager plugins;
        private final ExtensionContainer extensionContainer;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver, PluginManager plugins, ExtensionContainer extensionContainer) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
            this.plugins = plugins;
            this.extensionContainer = extensionContainer;
        }

        @Override
        public MavenPublication create(String name) {
            MutableMavenProjectIdentity projectIdentity = this.createProjectIdentity();
            Object artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            VersionMappingStrategyInternal versionMappingStrategy = MavenPublishPlugin.this.objectFactory.newInstance(DefaultVersionMappingStrategy.class, new Object[0]);
            this.configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(versionMappingStrategy);
            return MavenPublishPlugin.this.objectFactory.newInstance(DefaultMavenPublication.class, name, projectIdentity, artifactNotationParser, versionMappingStrategy);
        }

        private void configureDefaultConfigurationsUsedWhenMappingToResolvedVersions(VersionMappingStrategyInternal versionMappingStrategy) {
            this.plugins.withPlugin("org.gradle.java", plugin -> {
                SourceSet mainSourceSet = (SourceSet)this.extensionContainer.getByType(SourceSetContainer.class).getByName("main");
                versionMappingStrategy.defaultResolutionConfiguration("java-api", mainSourceSet.getCompileClasspathConfigurationName());
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", mainSourceSet.getRuntimeClasspathConfigurationName());
            });
            this.plugins.withPlugin("org.gradle.java-platform", plugin -> {
                versionMappingStrategy.defaultResolutionConfiguration("java-api", "classpath");
                versionMappingStrategy.defaultResolutionConfiguration("java-runtime", "classpath");
            });
        }

        private MutableMavenProjectIdentity createProjectIdentity() {
            Module module = this.dependencyMetaDataProvider.getModule();
            WritableMavenProjectIdentity projectIdentity = new WritableMavenProjectIdentity(MavenPublishPlugin.this.objectFactory);
            projectIdentity.getGroupId().set(MavenPublishPlugin.this.providerFactory.provider(module::getGroup));
            projectIdentity.getArtifactId().set(MavenPublishPlugin.this.providerFactory.provider(module::getName));
            projectIdentity.getVersion().set(MavenPublishPlugin.this.providerFactory.provider(module::getVersion));
            return projectIdentity;
        }
    }
}

