/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.io.File;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.reporting.ReportRenderer;

class SourceSetRenderer
extends ReportRenderer<LanguageSourceSet, TextReportBuilder> {
    static final Comparator<LanguageSourceSet> SORT_ORDER = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());

    SourceSetRenderer() {
    }

    @Override
    public void render(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        builder.heading(StringUtils.capitalize(sourceSet.getDisplayName()));
        this.renderSourceSetDirectories(sourceSet, builder);
        this.renderSourceSetDependencies(sourceSet, builder);
    }

    private void renderSourceSetDirectories(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        Set<File> srcDirs = sourceSet.getSource().getSrcDirs();
        if (srcDirs.isEmpty()) {
            builder.item("No source directories");
        } else {
            Set<String> filterIncludes;
            Set<String> excludes;
            for (File file : srcDirs) {
                builder.item("srcDir", file);
            }
            SourceDirectorySet source = sourceSet.getSource();
            Set<String> includes = source.getIncludes();
            if (!includes.isEmpty()) {
                builder.item("includes", includes);
            }
            if (!(excludes = source.getExcludes()).isEmpty()) {
                builder.item("excludes", excludes);
            }
            if (!(filterIncludes = source.getFilter().getIncludes()).isEmpty()) {
                builder.item("limit to", filterIncludes);
            }
        }
    }

    private void renderSourceSetDependencies(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        DependencySpecContainer dependencies;
        if (sourceSet instanceof DependentSourceSet && !(dependencies = ((DependentSourceSet)sourceSet).getDependencies()).isEmpty()) {
            builder.collection("dependencies", dependencies.getDependencies(), new ReportRenderer<DependencySpec, TextReportBuilder>(){

                @Override
                public void render(DependencySpec model, TextReportBuilder output) {
                    if (model instanceof ProjectDependencySpec) {
                        output.item(model.getDisplayName());
                    }
                }
            }, "dependencies");
        }
    }
}

