/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Transformers;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

public class Upload
extends ConventionTask {
    private Configuration configuration;
    private boolean uploadDescriptor;
    private File descriptorDestination;
    private RepositoryHandler repositories;

    @Inject
    protected ArtifactPublicationServices getPublicationServices() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void upload() {
        this.getLogger().info("Publishing configuration: {}", (Object)this.configuration);
        Module module = ((ConfigurationInternal)this.configuration).getModule();
        ArtifactPublisher artifactPublisher = this.getPublicationServices().createArtifactPublisher();
        File descriptorDestination = this.isUploadDescriptor() ? this.getDescriptorDestination() : null;
        List<PublicationAwareRepository> publishRepositories = CollectionUtils.collect(this.getRepositories(), Transformers.cast(PublicationAwareRepository.class));
        try {
            artifactPublisher.publish(publishRepositories, module, this.configuration, descriptorDestination);
        }
        catch (Exception e) {
            throw new PublishException(String.format("Could not publish configuration '%s'", this.configuration.getName()), e);
        }
    }

    @Input
    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public void setUploadDescriptor(boolean uploadDescriptor) {
        this.uploadDescriptor = uploadDescriptor;
    }

    @Internal
    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public void setDescriptorDestination(File descriptorDestination) {
        this.descriptorDestination = descriptorDestination;
    }

    @Internal
    public RepositoryHandler getRepositories() {
        if (this.repositories == null) {
            this.repositories = this.getPublicationServices().createRepositoryHandler();
        }
        return this.repositories;
    }

    @Internal
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public RepositoryHandler repositories(@Nullable Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    public RepositoryHandler repositories(Action<? super RepositoryHandler> configureAction) {
        RepositoryHandler repositories = this.getRepositories();
        configureAction.execute(repositories);
        return repositories;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    public FileCollection getArtifacts() {
        Configuration configuration = this.getConfiguration();
        return configuration.getAllArtifacts().getFiles();
    }
}

