/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;

public abstract class AbstractCompile
extends SourceTask {
    private final DirectoryProperty destinationDirectory = this.getProject().getObjects().directoryProperty();
    private FileCollection classpath;
    private String sourceCompatibility;
    private String targetCompatibility;

    public AbstractCompile() {
        this.destinationDirectory.convention(this.getProject().getProviders().provider(new BackwardCompatibilityOutputDirectoryConvention()));
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection configuration) {
        this.classpath = configuration;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @ReplacedBy(value="destinationDirectory")
    public File getDestinationDir() {
        return this.destinationDirectory.getAsFile().getOrNull();
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDirectory.set(destinationDir);
    }

    public void setDestinationDir(Provider<File> destinationDir) {
        this.destinationDirectory.set(this.getProject().getLayout().dir(destinationDir));
    }

    @Input
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public void setSourceCompatibility(String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Input
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    private class BackwardCompatibilityOutputDirectoryConvention
    implements Callable<Directory> {
        private boolean recursiveCall;

        private BackwardCompatibilityOutputDirectoryConvention() {
        }

        @Override
        public Directory call() throws Exception {
            File legacyValue;
            Method getter = GeneratedSubclasses.unpackType(AbstractCompile.this).getMethod("getDestinationDir", new Class[0]);
            if (getter.getDeclaringClass() == AbstractCompile.class) {
                return null;
            }
            if (this.recursiveCall) {
                return null;
            }
            this.recursiveCall = true;
            try {
                legacyValue = AbstractCompile.this.getDestinationDir();
            }
            finally {
                this.recursiveCall = false;
            }
            if (legacyValue == null) {
                return null;
            }
            return AbstractCompile.this.getProject().getLayout().getProjectDirectory().dir(legacyValue.getAbsolutePath());
        }
    }
}

