/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationReportingCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.SourceClassesMappingFileAccessor;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.FileNameDerivingClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.IncrementalCompilationResult;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaCompiler;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class JavaCompile
extends AbstractCompile
implements HasCompileOptions {
    private final CompileOptions compileOptions;
    private final FileCollection stableSources = this.getProject().files(this::getSource);
    private final ModularitySpec modularity;
    private File sourceClassesMappingFile;
    private final Property<JavaCompiler> javaCompiler;
    private final ObjectFactory objectFactory = this.getProject().getObjects();

    public JavaCompile() {
        this.compileOptions = this.objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.modularity = this.objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.javaCompiler = this.objectFactory.property(JavaCompiler.class);
        this.javaCompiler.finalizeValueOnRead();
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(this.compileOptions, this.getOutputs());
    }

    @Override
    @ReplacedBy(value="stableSources")
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    @Optional
    public Property<JavaCompiler> getJavaCompiler() {
        return this.javaCompiler;
    }

    @TaskAction
    protected void compile(InputChanges inputs) {
        DefaultJavaCompileSpec spec = this.createSpec();
        if (!this.compileOptions.isIncremental()) {
            this.performFullCompilation(spec);
        } else {
            this.performIncrementalCompilation(inputs, spec);
        }
    }

    private void validateConfiguration() {
        if (this.javaCompiler.isPresent()) {
            Preconditions.checkState(this.getOptions().getForkOptions().getJavaHome() == null, "Must not use `javaHome` property on `ForkOptions` together with `javaCompiler` property");
            Preconditions.checkState(this.getOptions().getForkOptions().getExecutable() == null, "Must not use `executable` property on `ForkOptions` together with `javaCompiler` property");
        }
    }

    private void performIncrementalCompilation(InputChanges inputs, DefaultJavaCompileSpec spec) {
        SourceFileClassNameConverter sourceFileClassNameConverter;
        Multimap<String, String> oldMappings;
        boolean isUsingCliCompiler = this.isUsingCliCompiler(spec);
        File sourceClassesMappingFile = this.getSourceClassesMappingFile();
        if (isUsingCliCompiler) {
            oldMappings = null;
            sourceFileClassNameConverter = new FileNameDerivingClassNameConverter();
        } else {
            oldMappings = SourceClassesMappingFileAccessor.readSourceClassesMappingFile(sourceClassesMappingFile);
            sourceFileClassNameConverter = new DefaultSourceFileClassNameConverter(oldMappings);
        }
        sourceClassesMappingFile.delete();
        spec.getCompileOptions().setIncrementalCompilationMappingFile(sourceClassesMappingFile);
        Compiler<JavaCompileSpec> compiler = this.createCompiler();
        compiler = this.makeIncremental(inputs, sourceFileClassNameConverter, (CleaningJavaCompiler<JavaCompileSpec>)compiler, this.getStableSources().getAsFileTree());
        WorkResult workResult = this.performCompilation(spec, compiler);
        if (workResult instanceof IncrementalCompilationResult && !isUsingCliCompiler) {
            SourceClassesMappingFileAccessor.mergeIncrementalMappingsIntoOldMappings(sourceClassesMappingFile, this.getStableSources(), inputs, oldMappings);
        }
    }

    private Compiler<JavaCompileSpec> makeIncremental(InputChanges inputs, SourceFileClassNameConverter sourceFileClassNameConverter, CleaningJavaCompiler<JavaCompileSpec> compiler, FileTree sources) {
        return this.getIncrementalCompilerFactory().makeIncremental(compiler, this.getPath(), sources, this.createRecompilationSpec(inputs, sourceFileClassNameConverter, sources));
    }

    private JavaRecompilationSpecProvider createRecompilationSpec(InputChanges inputs, SourceFileClassNameConverter sourceFileClassNameConverter, FileTree sources) {
        return new JavaRecompilationSpecProvider(this.getDeleter(), this.getServices().get(FileOperations.class), sources, inputs.isIncremental(), () -> inputs.getFileChanges(this.getStableSources()).iterator(), sourceFileClassNameConverter);
    }

    private boolean isUsingCliCompiler(DefaultJavaCompileSpec spec) {
        return CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass());
    }

    private void performFullCompilation(DefaultJavaCompileSpec spec) {
        spec.setSourceFiles(this.getStableSources());
        CleaningJavaCompiler<JavaCompileSpec> compiler = this.createCompiler();
        this.performCompilation(spec, compiler);
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getJavaToolchainService() {
        throw new UnsupportedOperationException();
    }

    CleaningJavaCompiler<JavaCompileSpec> createCompiler() {
        Compiler javaCompiler = this.createToolchainCompiler();
        return new CleaningJavaCompiler<JavaCompileSpec>(javaCompiler, this.getOutputs(), this.getDeleter());
    }

    private <T extends CompileSpec> Compiler<T> createToolchainCompiler() {
        return spec -> {
            Provider<JavaCompiler> compilerProvider = this.getCompilerTool();
            DefaultToolchainJavaCompiler compiler = (DefaultToolchainJavaCompiler)compilerProvider.get();
            return compiler.execute(spec);
        };
    }

    private Provider<JavaCompiler> getCompilerTool() {
        JavaToolchainSpec explicitToolchain = this.determineExplicitToolchain();
        if (explicitToolchain == null) {
            if (this.javaCompiler.isPresent()) {
                return this.javaCompiler;
            }
            explicitToolchain = new CurrentJvmToolchainSpec(this.objectFactory);
        }
        return this.getJavaToolchainService().compilerFor(explicitToolchain);
    }

    @Nullable
    private JavaToolchainSpec determineExplicitToolchain() {
        File executable;
        File customJavaHome = this.getOptions().getForkOptions().getJavaHome();
        if (customJavaHome != null) {
            return new SpecificInstallationToolchainSpec(this.objectFactory, customJavaHome);
        }
        String customExecutable = this.getOptions().getForkOptions().getExecutable();
        if (customExecutable != null && (executable = new File(customExecutable)).exists()) {
            return new SpecificInstallationToolchainSpec(this.objectFactory, executable.getParentFile().getParentFile());
        }
        return null;
    }

    @LocalState
    protected File getSourceClassesMappingFile() {
        if (this.sourceClassesMappingFile == null) {
            File tmpDir = this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
            this.sourceClassesMappingFile = new File(tmpDir, "source-classes-mapping.txt");
        }
        return this.sourceClassesMappingFile;
    }

    private WorkResult performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = new CompileJavaBuildOperationReportingCompiler(this, compiler, this.getServices().get(BuildOperationExecutor.class)).execute(spec);
        this.setDidWork(result.getDidWork());
        return result;
    }

    DefaultJavaCompileSpec createSpec() {
        this.validateConfiguration();
        List<File> sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)this.getStableSources().getAsFileTree());
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        boolean isModule = JavaModuleDetector.isModuleSource((Boolean)this.modularity.getInferModulePath().get(), sourcesRoots);
        boolean toolchainCompatibleWithJava8 = this.isToolchainCompatibleWithJava8();
        DefaultJavaCompileSpec spec = this.createBaseSpec();
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath(ImmutableList.copyOf(javaModuleDetector.inferClasspath(isModule, this.getClasspath())));
        spec.setModulePath(ImmutableList.copyOf(javaModuleDetector.inferModulePath(isModule, this.getClasspath())));
        if (isModule) {
            this.compileOptions.setSourcepath(this.getProjectLayout().files(sourcesRoots));
        }
        spec.setAnnotationProcessorPath(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf(this.compileOptions.getAnnotationProcessorPath()));
        this.configureCompatibilityOptions(spec);
        spec.setSourcesRoots(sourcesRoots);
        if (!toolchainCompatibleWithJava8) {
            spec.getCompileOptions().setHeaderOutputDirectory(null);
        }
        return spec;
    }

    private boolean isToolchainCompatibleWithJava8() {
        return this.getCompilerTool().get().getMetadata().getLanguageVersion().canCompileOrRun(8);
    }

    @Input
    JavaVersion getJavaVersion() {
        return JavaVersion.toVersion(this.getCompilerTool().get().getMetadata().getLanguageVersion().asInt());
    }

    private DefaultJavaCompileSpec createBaseSpec() {
        ForkOptions forkOptions = this.compileOptions.getForkOptions();
        if (this.javaCompiler.isPresent()) {
            this.applyToolchain(forkOptions);
        }
        return (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
    }

    private void applyToolchain(ForkOptions forkOptions) {
        JavaInstallationMetadata metadata = this.getToolchain();
        forkOptions.setJavaHome(metadata.getInstallationPath().getAsFile());
    }

    @Nullable
    private JavaInstallationMetadata getToolchain() {
        return this.javaCompiler.map(JavaCompiler::getMetadata).getOrNull();
    }

    private void configureCompatibilityOptions(DefaultJavaCompileSpec spec) {
        JavaInstallationMetadata toolchain = this.getToolchain();
        if (toolchain != null) {
            if (this.compileOptions.getRelease().isPresent()) {
                spec.setRelease((Integer)this.compileOptions.getRelease().get());
            } else {
                boolean isSourceOrTargetConfigured = false;
                if (super.getSourceCompatibility() != null) {
                    spec.setSourceCompatibility(this.getSourceCompatibility());
                    isSourceOrTargetConfigured = true;
                }
                if (super.getTargetCompatibility() != null) {
                    spec.setTargetCompatibility(this.getTargetCompatibility());
                    isSourceOrTargetConfigured = true;
                }
                if (!isSourceOrTargetConfigured) {
                    JavaLanguageVersion languageVersion = toolchain.getLanguageVersion();
                    if (languageVersion.canCompileOrRun(10)) {
                        spec.setRelease(languageVersion.asInt());
                    } else {
                        String version = languageVersion.toString();
                        spec.setSourceCompatibility(version);
                        spec.setTargetCompatibility(version);
                    }
                }
            }
        } else if (this.compileOptions.getRelease().isPresent()) {
            spec.setRelease((Integer)this.compileOptions.getRelease().get());
        } else {
            spec.setTargetCompatibility(this.getTargetCompatibility());
            spec.setSourceCompatibility(this.getSourceCompatibility());
        }
        spec.setCompileOptions(this.compileOptions);
    }

    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Override
    @CompileClasspath
    @Incremental
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }
}

