/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dependencies;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphsRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.SimpleNodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.GUtil;

@NonNullApi
public class AsciiDependencyReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private final ConfigurationAction configurationAction = new ConfigurationAction();
    private boolean hasConfigs;
    private GraphRenderer renderer;
    DependencyGraphsRenderer dependencyGraphRenderer;

    @Override
    public void startProject(ProjectDetails project) {
        super.startProject(project);
        this.prepareVisit();
    }

    void prepareVisit() {
        this.hasConfigs = false;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.dependencyGraphRenderer = new DependencyGraphsRenderer(this.getTextOutput(), this.renderer, NodeRenderer.NO_OP, new SimpleNodeRenderer());
    }

    @Override
    public void completeProject(ProjectDetails project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No configurations");
        }
        super.completeProject(project);
    }

    @Override
    public void startConfiguration(Configuration configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.configurationAction.setConfiguration(configuration);
        this.renderer.visit(this.configurationAction, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue(configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    @Override
    public void completeConfiguration(Configuration configuration) {
    }

    @Override
    public void render(Configuration configuration) {
        if (this.canBeResolved(configuration)) {
            ResolutionResult result = configuration.getIncoming().getResolutionResult();
            RenderableModuleResult root = new RenderableModuleResult(result.getRoot());
            this.renderNow(root);
        } else {
            this.renderNow(new UnresolvableConfigurationResult(configuration));
        }
    }

    private boolean canBeResolved(Configuration configuration) {
        boolean isDeprecatedForResolving = ((DeprecatableConfiguration)configuration).getResolutionAlternatives() != null;
        return configuration.isCanBeResolved() && !isDeprecatedForResolving;
    }

    void renderNow(RenderableDependency root) {
        if (root.getChildren().isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text("No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.dependencyGraphRenderer.render(Collections.singletonList(root));
    }

    @Override
    public void complete() {
        if (this.dependencyGraphRenderer != null) {
            this.dependencyGraphRenderer.complete();
        }
        this.getTextOutput().println();
        this.getTextOutput().text("A web-based, searchable dependency report is available by adding the ");
        this.getTextOutput().withStyle(StyledTextOutput.Style.UserInput).format("--%s", "scan");
        this.getTextOutput().println(" option.");
        super.complete();
    }

    private class ConfigurationAction
    implements Action<StyledTextOutput> {
        private Configuration configuration;

        private ConfigurationAction() {
        }

        @Override
        public void execute(StyledTextOutput styledTextOutput) {
            AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(this.configuration.getName());
            AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text(AsciiDependencyReportRenderer.this.getDescription(this.configuration));
            if (!AsciiDependencyReportRenderer.this.canBeResolved(this.configuration)) {
                AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text(" (n)");
            }
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }
    }
}

