/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.PackageNameBuilder;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.logging.text.TreeFormatter;

public class InitBuild
extends DefaultTask {
    private final Directory projectDir = this.getProject().getLayout().getProjectDirectory();
    private String type;
    private final Property<Boolean> splitProject = this.getProject().getObjects().property(Boolean.class);
    private String dsl;
    private String testFramework;
    private String projectName;
    private String packageName;
    @Internal
    private ProjectLayoutSetupRegistry projectLayoutRegistry;

    @Input
    public String getType() {
        return Strings.isNullOrEmpty(this.type) ? this.detectType() : this.type;
    }

    @Input
    @Optional
    @Option(option="split-project", description="Split functionality across multiple subprojects?")
    public Property<Boolean> getSplitProject() {
        return this.splitProject;
    }

    @Optional
    @Input
    public String getDsl() {
        return Strings.isNullOrEmpty(this.dsl) ? BuildInitDsl.GROOVY.getId() : this.dsl;
    }

    @Input
    public String getProjectName() {
        return this.projectName == null ? this.projectDir.getAsFile().getName() : this.projectName;
    }

    @Input
    public String getPackageName() {
        return this.packageName == null ? "" : this.packageName;
    }

    @Nullable
    @Optional
    @Input
    public String getTestFramework() {
        return this.testFramework;
    }

    public ProjectLayoutSetupRegistry getProjectLayoutRegistry() {
        if (this.projectLayoutRegistry == null) {
            this.projectLayoutRegistry = this.getServices().get(ProjectLayoutSetupRegistry.class);
        }
        return this.projectLayoutRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public void setupProjectLayout() {
        void var8_12;
        BuildInitDsl dsl;
        UserInputHandler inputHandler = this.getServices().get(UserInputHandler.class);
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildInitializer initDescriptor = null;
        if (Strings.isNullOrEmpty(this.type)) {
            BuildConverter converter = projectLayoutRegistry.getBuildConverter();
            if (converter.canApplyToCurrentDirectory(this.projectDir) && inputHandler.askYesNoQuestion("Found a " + converter.getSourceBuildDescription() + " build. Generate a Gradle build from this?", true)) {
                initDescriptor = converter;
            }
            if (initDescriptor == null) {
                ComponentType componentType = inputHandler.selectOption("Select type of project to generate", projectLayoutRegistry.getComponentTypes(), projectLayoutRegistry.getDefault().getComponentType());
                List<Language> languages = projectLayoutRegistry.getLanguagesFor(componentType);
                if (languages.size() == 1) {
                    initDescriptor = projectLayoutRegistry.get(componentType, languages.get(0));
                } else {
                    if (!languages.contains(Language.JAVA)) {
                        throw new UnsupportedOperationException();
                    }
                    Language language = inputHandler.selectOption("Select implementation language", languages, Language.JAVA);
                    initDescriptor = projectLayoutRegistry.get(componentType, language);
                }
            }
        } else {
            initDescriptor = projectLayoutRegistry.get(this.type);
        }
        ModularizationOption modularizationOption = this.splitProject.isPresent() ? ((Boolean)this.splitProject.get() != false ? ModularizationOption.WITH_LIBRARY_PROJECTS : ModularizationOption.SINGLE_PROJECT) : (initDescriptor.getModularizationOptions().size() == 1 ? initDescriptor.getModularizationOptions().iterator().next() : (!Strings.isNullOrEmpty(this.type) ? ModularizationOption.SINGLE_PROJECT : inputHandler.selectOption("Split functionality across multiple subprojects?", initDescriptor.getModularizationOptions(), ModularizationOption.SINGLE_PROJECT)));
        if (Strings.isNullOrEmpty(this.dsl)) {
            dsl = initDescriptor.getDefaultDsl();
            if (initDescriptor.getDsls().size() > 1) {
                dsl = inputHandler.selectOption("Select build script DSL", initDescriptor.getDsls(), dsl);
            }
        } else {
            dsl = BuildInitDsl.fromName(this.getDsl());
            if (!initDescriptor.getDsls().contains(dsl)) {
                throw new GradleException("The requested DSL '" + this.getDsl() + "' is not supported for '" + initDescriptor.getId() + "' build type");
            }
        }
        BuildInitTestFramework testFramework = null;
        if (modularizationOption == ModularizationOption.WITH_LIBRARY_PROJECTS) {
            testFramework = BuildInitTestFramework.JUNIT_JUPITER;
        } else if (Strings.isNullOrEmpty(this.testFramework)) {
            testFramework = initDescriptor.getDefaultTestFramework();
            if (initDescriptor.getTestFrameworks().size() > 1) {
                testFramework = inputHandler.selectOption("Select test framework", initDescriptor.getTestFrameworks(), testFramework);
            }
        } else {
            for (BuildInitTestFramework buildInitTestFramework : initDescriptor.getTestFrameworks()) {
                if (!this.testFramework.equals(buildInitTestFramework.getId())) continue;
                testFramework = buildInitTestFramework;
                break;
            }
            if (testFramework == null) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("The requested test framework '" + this.getTestFramework() + "' is not supported for '" + initDescriptor.getId() + "' build type. Supported frameworks");
                formatter.startChildren();
                for (BuildInitTestFramework framework : initDescriptor.getTestFrameworks()) {
                    formatter.node("'" + framework.getId() + "'");
                }
                formatter.endChildren();
                throw new GradleException(formatter.toString());
            }
        }
        String projectName = this.projectName;
        if (initDescriptor.supportsProjectName()) {
            if (Strings.isNullOrEmpty(projectName)) {
                projectName = inputHandler.askQuestion("Project name", this.getProjectName());
            }
        } else if (!Strings.isNullOrEmpty(projectName)) {
            throw new GradleException("Project name is not supported for '" + initDescriptor.getId() + "' build type.");
        }
        String string2 = this.packageName;
        if (initDescriptor.supportsPackage()) {
            if (Strings.isNullOrEmpty(string2)) {
                String string3 = inputHandler.askQuestion("Source package", PackageNameBuilder.toPackageName(projectName));
            }
        } else if (!Strings.isNullOrEmpty(string2)) {
            throw new GradleException("Package name is not supported for '" + initDescriptor.getId() + "' build type.");
        }
        List<String> subprojectNames = initDescriptor.getComponentType().getDefaultProjectNames();
        InitSettings settings = new InitSettings(projectName, subprojectNames, modularizationOption, dsl, (String)var8_12, testFramework, this.projectDir);
        initDescriptor.generate(settings);
        initDescriptor.getFurtherReading(settings).ifPresent(link -> this.getLogger().lifecycle("Get more help with your project: {}", link));
    }

    @Option(option="type", description="Set the type of project to generate.")
    public void setType(String type) {
        this.type = type;
    }

    @OptionValues(value={"type"})
    public List<String> getAvailableBuildTypes() {
        return this.getProjectLayoutRegistry().getAllTypes();
    }

    @Option(option="dsl", description="Set the build script DSL to be used in generated scripts.")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    @OptionValues(value={"dsl"})
    public List<String> getAvailableDSLs() {
        return BuildInitDsl.listSupported();
    }

    @Option(option="test-framework", description="Set the test framework to be used.")
    public void setTestFramework(@Nullable String testFramework) {
        this.testFramework = testFramework;
    }

    @OptionValues(value={"test-framework"})
    public List<String> getAvailableTestFrameworks() {
        return BuildInitTestFramework.listSupported();
    }

    @Option(option="project-name", description="Set the project name.")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Option(option="package", description="Set the package for source files.")
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    void setProjectLayoutRegistry(ProjectLayoutSetupRegistry projectLayoutRegistry) {
        this.projectLayoutRegistry = projectLayoutRegistry;
    }

    private String detectType() {
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildConverter buildConverter = projectLayoutRegistry.getBuildConverter();
        if (buildConverter.canApplyToCurrentDirectory(this.projectDir)) {
            return buildConverter.getId();
        }
        return projectLayoutRegistry.getDefault().getId();
    }
}

