/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.gradle.internal.impldep.com.google.common.io.CountingInputStream;
import org.gradle.internal.io.RandomAccessFileInputStream;

class ByteInput {
    private final RandomAccessFile file;
    private final ResettableBufferedInputStream bufferedInputStream;
    private CountingInputStream countingInputStream;

    public ByteInput(RandomAccessFile file) {
        this.file = file;
        this.bufferedInputStream = new ResettableBufferedInputStream(new RandomAccessFileInputStream(file));
    }

    public DataInputStream start(long offset) throws IOException {
        this.file.seek(offset);
        this.bufferedInputStream.clear();
        this.countingInputStream = new CountingInputStream(this.bufferedInputStream);
        return new DataInputStream(this.countingInputStream);
    }

    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    public void done() {
        this.countingInputStream = null;
    }

    private static class ResettableBufferedInputStream
    extends BufferedInputStream {
        ResettableBufferedInputStream(InputStream input) {
            super(input);
        }

        void clear() {
            this.count = 0;
            this.pos = 0;
        }
    }
}

