/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.gradle.internal.impldep.com.google.common.io.CountingOutputStream;
import org.gradle.internal.io.RandomAccessFileOutputStream;

class ByteOutput {
    private final RandomAccessFile file;
    private final ResettableBufferedOutputStream bufferedOutputStream;
    private CountingOutputStream countingOutputStream;

    public ByteOutput(RandomAccessFile file) {
        this.file = file;
        this.bufferedOutputStream = new ResettableBufferedOutputStream(new RandomAccessFileOutputStream(file));
    }

    public DataOutputStream start(long offset) throws IOException {
        this.file.seek(offset);
        this.bufferedOutputStream.clear();
        this.countingOutputStream = new CountingOutputStream(this.bufferedOutputStream);
        return new DataOutputStream(this.countingOutputStream);
    }

    public long getBytesWritten() {
        return this.countingOutputStream.getCount();
    }

    public void done() throws IOException {
        this.countingOutputStream.flush();
        this.countingOutputStream = null;
    }

    private static class ResettableBufferedOutputStream
    extends BufferedOutputStream {
        ResettableBufferedOutputStream(OutputStream output) {
            super(output);
        }

        void clear() {
            this.count = 0;
        }
    }
}

