/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ForeignBuildIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeParticipantBuildState
extends AbstractBuildState
implements CompositeBuildParticipantBuildState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompositeParticipantBuildState.class);
    private Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules;

    @Override
    public synchronized Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        if (this.availableModules == null) {
            GradleInternal gradle = this.getBuild();
            this.availableModules = new LinkedHashSet<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>>();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                this.registerProject(this.availableModules, (ProjectInternal)project);
            }
        }
        return this.availableModules;
    }

    private void registerProject(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules, ProjectInternal project) {
        DefaultProjectComponentIdentifier projectIdentifier = new DefaultProjectComponentIdentifier(this.getBuildIdentifier(), project.getIdentityPath(), project.getProjectPath(), project.getName());
        ModuleVersionIdentifier moduleId = DefaultModuleVersionIdentifier.newId(project.getModule());
        LOGGER.info("Registering {} in composite build. Will substitute for module '{}'.", (Object)project, (Object)moduleId.getModule());
        availableModules.add(Pair.of(moduleId, projectIdentifier));
    }

    @Override
    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier original = (DefaultProjectComponentIdentifier)identifier;
        String name = this.getIdentityPath().getName();
        if (name == null) {
            name = this.getBuildIdentifier().getName();
        }
        return new DefaultProjectComponentIdentifier(new ForeignBuildIdentifier(this.getBuildIdentifier().getName(), name), original.getIdentityPath(), original.projectPath(), original.getProjectName());
    }
}

