/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.BuildResult;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.execution.taskgraph.TaskListenerInternal;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIncludedBuildController
implements Runnable,
Stoppable,
IncludedBuildController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuildController.class);
    private final IncludedBuildState includedBuild;
    private final ResourceLockCoordinationService coordinationService;
    private final ProjectStateRegistry projectStateRegistry;
    private final Lock lock = new ReentrantLock();
    private final Condition stateChange = this.lock.newCondition();
    private final Map<String, TaskState> tasks = new LinkedHashMap<String, TaskState>();
    private final Set<String> tasksAdded = new HashSet<String>();
    private final List<Throwable> taskFailures = new ArrayList<Throwable>();
    private State state = State.CollectingTasks;
    private boolean stopRequested;

    public DefaultIncludedBuildController(IncludedBuildState includedBuild, ResourceLockCoordinationService coordinationService, ProjectStateRegistry projectStateRegistry) {
        this.includedBuild = includedBuild;
        this.coordinationService = coordinationService;
        this.projectStateRegistry = projectStateRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean populateTaskGraph() {
        LinkedHashSet<String> tasksToExecute = new LinkedHashSet<String>();
        this.lock.lock();
        try {
            if (this.state != State.CollectingTasks) {
                throw new IllegalStateException();
            }
            for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
                String taskName;
                if (taskEntry.getValue().status != TaskStatus.QUEUED || !this.tasksAdded.add(taskName = taskEntry.getKey())) continue;
                tasksToExecute.add(taskName);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (tasksToExecute.isEmpty()) {
            return false;
        }
        this.includedBuild.addTasks(tasksToExecute);
        return true;
    }

    @Override
    public void run() {
        Set<String> tasksToExecute;
        while ((tasksToExecute = this.getQueuedTasks()) != null) {
            try {
                this.doBuild(tasksToExecute);
                continue;
            }
            finally {
                this.setState(State.CollectingTasks);
                continue;
            }
            break;
        }
        return;
    }

    private void setState(State state2) {
        this.lock.lock();
        try {
            this.state = state2;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void startTaskExecution() {
        this.setState(State.RunningTasks);
    }

    @Override
    public void awaitTaskCompletion(Collection<? super Throwable> taskFailures) {
        this.projectStateRegistry.blocking(() -> {
            this.lock.lock();
            try {
                while (this.state == State.RunningTasks) {
                    this.awaitStateChange();
                }
                taskFailures.addAll(this.taskFailures);
                this.taskFailures.clear();
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    @Override
    public TaskInternal getTask(String taskPath) {
        for (Task task : this.getTaskGraph().getAllTasks()) {
            if (!task.getPath().equals(taskPath)) continue;
            return (TaskInternal)task;
        }
        throw this.includedBuildTaskWasNeverScheduled(taskPath);
    }

    private TaskExecutionGraphInternal getTaskGraph() {
        return this.includedBuild.getBuild().getTaskGraph();
    }

    @Override
    public void stop() {
        ArrayList failures = new ArrayList();
        this.awaitTaskCompletion(failures);
        if (!failures.isEmpty()) {
            throw new MultipleBuildFailures(failures);
        }
        this.lock.lock();
        try {
            this.stopRequested = true;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getQueuedTasks() {
        this.lock.lock();
        try {
            while (this.state == State.CollectingTasks && !this.stopRequested) {
                this.awaitStateChange();
            }
            if (this.stopRequested) {
                Set<String> set2 = null;
                return set2;
            }
            LinkedHashSet<String> tasksToExecute = new LinkedHashSet<String>();
            for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
                if (taskEntry.getValue().status != TaskStatus.QUEUED) continue;
                tasksToExecute.add(taskEntry.getKey());
                taskEntry.getValue().status = TaskStatus.EXECUTING;
            }
            LinkedHashSet<String> linkedHashSet = tasksToExecute;
            return linkedHashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitStateChange() {
        try {
            this.stateChange.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void doBuild(Collection<String> tasksToExecute) {
        if (tasksToExecute.isEmpty()) {
            return;
        }
        LOGGER.info("Executing {} tasks {}", (Object)this.includedBuild.getName(), (Object)tasksToExecute);
        IncludedBuildExecutionListener listener = new IncludedBuildExecutionListener(tasksToExecute);
        try {
            this.includedBuild.execute(tasksToExecute, listener);
            this.tasksDone(tasksToExecute, null);
        }
        catch (RuntimeException failure) {
            this.tasksDone(tasksToExecute, failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskCompleted(String task, Throwable failure) {
        this.lock.lock();
        try {
            TaskState taskState = this.tasks.get(task);
            if (taskState == null) {
                taskState = new TaskState();
                this.tasks.put(task, taskState);
            }
            taskState.status = failure == null ? TaskStatus.SUCCESS : TaskStatus.FAILED;
        }
        finally {
            this.lock.unlock();
        }
        this.coordinationService.notifyStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tasksDone(Collection<String> tasksExecuted, @Nullable RuntimeException failure) {
        boolean someTasksNotCompleted = false;
        this.lock.lock();
        try {
            for (String task : tasksExecuted) {
                TaskState taskState = this.tasks.get(task);
                if (taskState.status != TaskStatus.EXECUTING) continue;
                taskState.status = TaskStatus.FAILED;
                someTasksNotCompleted = true;
            }
            if (failure != null) {
                if (failure instanceof MultipleBuildFailures) {
                    this.taskFailures.addAll(((MultipleBuildFailures)failure).getCauses());
                } else {
                    this.taskFailures.add(failure);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (someTasksNotCompleted) {
            this.coordinationService.notifyStateChange();
        }
    }

    @Override
    public void queueForExecution(String taskPath) {
        this.lock.lock();
        try {
            if (this.state != State.CollectingTasks) {
                throw new IllegalStateException();
            }
            if (!this.tasks.containsKey(taskPath)) {
                this.tasks.put(taskPath, new TaskState());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncludedBuildTaskResource.State getTaskState(String taskPath) {
        this.lock.lock();
        try {
            TaskState state2 = this.tasks.get(taskPath);
            if (state2 == null) {
                throw this.includedBuildTaskWasNeverScheduled(taskPath);
            }
            if (state2.status == TaskStatus.FAILED) {
                IncludedBuildTaskResource.State state3 = IncludedBuildTaskResource.State.FAILED;
                return state3;
            }
            if (state2.status == TaskStatus.SUCCESS) {
                IncludedBuildTaskResource.State state4 = IncludedBuildTaskResource.State.SUCCESS;
                return state4;
            }
            IncludedBuildTaskResource.State state5 = IncludedBuildTaskResource.State.WAITING;
            return state5;
        }
        finally {
            this.lock.unlock();
        }
    }

    private IllegalStateException includedBuildTaskWasNeverScheduled(String taskPath) {
        return new IllegalStateException("Included build task '" + taskPath + "' was never scheduled for execution.");
    }

    private class IncludedBuildExecutionListener
    implements TaskExecutionGraphListener,
    TaskListenerInternal {
        private final Collection<String> tasksToExecute;

        IncludedBuildExecutionListener(Collection<String> tasksToExecute) {
            this.tasksToExecute = tasksToExecute;
        }

        @Override
        public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
            for (String task : this.tasksToExecute) {
                if (taskExecutionGraph.hasTask(task)) continue;
                throw new GradleException("Task '" + task + "' not found in build '" + DefaultIncludedBuildController.this.includedBuild.getName() + "'.");
            }
        }

        @Override
        public void beforeExecute(TaskIdentity<?> taskIdentity) {
        }

        @Override
        public void afterExecute(TaskIdentity<?> taskIdentity, org.gradle.api.tasks.TaskState state2) {
            Throwable failure = state2.getFailure();
            DefaultIncludedBuildController.this.taskCompleted(taskIdentity.getTaskPath(), failure);
        }
    }

    private static class TaskState {
        public BuildResult result;
        public TaskStatus status = TaskStatus.QUEUED;

        private TaskState() {
        }
    }

    private static enum TaskStatus {
        QUEUED,
        EXECUTING,
        FAILED,
        SUCCESS;

    }

    private static enum State {
        CollectingTasks,
        RunningTasks;

    }
}

