/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.concurrent.ExecutionException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;

public class LocalComponentInAnotherBuildProvider
implements LocalComponentProvider {
    private final ProjectStateRegistry projectRegistry;
    private final IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder;
    private final LoadingCache<ProjectComponentIdentifier, LocalComponentMetadata> projectMetadata = CacheBuilder.newBuilder().build(new CacheLoader<ProjectComponentIdentifier, LocalComponentMetadata>(){

        @Override
        public LocalComponentMetadata load(ProjectComponentIdentifier projectIdentifier) {
            return LocalComponentInAnotherBuildProvider.this.getRegisteredProject(projectIdentifier);
        }
    });

    public LocalComponentInAnotherBuildProvider(ProjectStateRegistry projectRegistry, IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder) {
        this.projectRegistry = projectRegistry;
        this.dependencyMetadataBuilder = dependencyMetadataBuilder;
    }

    @Override
    public LocalComponentMetadata getComponent(ProjectComponentIdentifier project) {
        try {
            return this.projectMetadata.get(project);
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    private LocalComponentMetadata getRegisteredProject(ProjectComponentIdentifier projectId) {
        ProjectState projectState = this.projectRegistry.stateFor(projectId);
        CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)projectState.getOwner();
        if (buildState instanceof IncludedBuildState) {
            ((IncludedBuildState)buildState).getConfiguredBuild();
        }
        return projectState.fromMutableState(p -> this.dependencyMetadataBuilder.build(buildState, projectId));
    }
}

