/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements NestedRootBuild {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildState owner;
    private final GradleLauncher gradleLauncher;
    private String buildName;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.owner = owner;
        this.buildName = buildDefinition.getName() == null ? buildIdentifier.getName() : buildDefinition.getName();
        this.gradleLauncher = owner.getNestedBuildFactory().nestedBuildTree(buildDefinition, this);
    }

    public void attach() {
        this.gradleLauncher.getGradle().getServices().get(BuildStateRegistry.class).attachRootBuild(this);
    }

    @Override
    public StartParameter getStartParameter() {
        return this.gradleLauncher.getGradle().getStartParameter();
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return false;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    @Override
    public NestedBuildFactory getNestedBuildFactory() {
        return this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildName);
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.gradleLauncher.getGradle().getIdentityPath().append(projectPath);
    }

    @Override
    public File getBuildRootDir() {
        return this.gradleLauncher.getBuildRootDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(final Transformer<T, ? super BuildController> buildAction) {
        final GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        try {
            final GradleInternal gradle = this.gradleLauncher.getGradle();
            BuildOperationExecutor executor = gradle.getServices().get(BuildOperationExecutor.class);
            Object t = executor.call(new CallableBuildOperation<T>(){

                @Override
                public T call(BuildOperationContext context) {
                    gradle.addBuildListener(new InternalBuildAdapter(){

                        @Override
                        public void settingsEvaluated(Settings settings) {
                            RootOfNestedBuildTree.this.buildName = settings.getRootProject().getName();
                        }
                    });
                    Object result = buildAction.transform(buildController);
                    context.setResult(new RunNestedBuildBuildOperationType.Result(){});
                    return result;
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Run nested build").details(new RunNestedBuildBuildOperationType.Details(){

                        @Override
                        public String getBuildPath() {
                            return gradle.getIdentityPath().getPath();
                        }
                    });
                }
            });
            return t;
        }
        finally {
            buildController.stop();
        }
    }

    @Override
    public GradleInternal getBuild() {
        return this.gradleLauncher.getGradle();
    }
}

