/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.configuration.ImportsReader;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.io.LineProcessor;
import org.gradle.internal.impldep.com.google.common.io.Resources;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class DefaultImportsReader
implements ImportsReader {
    private static final String RESOURCE = "/default-imports.txt";
    private static final String MAPPING_RESOURCE = "/api-mapping.txt";
    private final String[] importPackages;
    private final Map<String, List<String>> simpleNameToFQCN;

    public DefaultImportsReader() {
        try {
            this.importPackages = DefaultImportsReader.generateImportPackages();
            this.simpleNameToFQCN = DefaultImportsReader.generateSimpleNameToFQCN();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String[] getImportPackages() {
        return this.importPackages;
    }

    @Override
    public Map<String, List<String>> getSimpleNameToFullClassNamesMapping() {
        return this.simpleNameToFQCN;
    }

    private static String[] generateImportPackages() throws IOException {
        URL url = DefaultImportsReader.class.getResource(RESOURCE);
        if (url == null) {
            throw new IllegalStateException("Could not load default imports resource: /default-imports.txt");
        }
        return Resources.asCharSource(url, Charsets.UTF_8).readLines(new LineProcessor<String[]>(){
            private final List<String> packages = Lists.newLinkedList();

            @Override
            public boolean processLine(String line) throws IOException {
                this.packages.add(line.substring(7, line.length() - 2));
                return true;
            }

            @Override
            public String[] getResult() {
                return this.packages.toArray(new String[this.packages.size()]);
            }
        });
    }

    private static Map<String, List<String>> generateSimpleNameToFQCN() throws IOException {
        URL url = DefaultImportsReader.class.getResource(MAPPING_RESOURCE);
        if (url == null) {
            throw new IllegalStateException("Could not load default imports resource: /api-mapping.txt");
        }
        return Resources.asCharSource(url, Charsets.UTF_8).readLines(new LineProcessor<Map<String, List<String>>>(){
            private final ImmutableMap.Builder<String, List<String>> builder = ImmutableMap.builder();

            @Override
            public boolean processLine(String line) throws IOException {
                boolean process;
                boolean bl = process = !StringUtils.isEmpty(line);
                if (process) {
                    String[] split = line.split(":");
                    if (split.length == 2) {
                        String simpleName = split[0];
                        List<String> fqcns = Splitter.on(';').omitEmptyStrings().splitToList(split[1]);
                        this.builder.put(simpleName, fqcns);
                    } else {
                        process = false;
                    }
                }
                return process;
            }

            @Override
            public Map<String, List<String>> getResult() {
                return this.builder.build();
            }
        });
    }
}

