/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.properties.DefaultTaskProperties;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.impl.DefaultWorkValidationContext;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.ServiceRegistry;

public class LocalTaskNode
extends TaskNode {
    private final TaskInternal task;
    private final WorkValidationContext validationContext;
    private ImmutableActionSet<Task> postAction = ImmutableActionSet.empty();
    private boolean isolated;
    private List<? extends ResourceLock> resourceLocks;
    private TaskProperties taskProperties;

    public LocalTaskNode(TaskInternal task, DocumentationRegistry documentationRegistry) {
        this.task = task;
        this.validationContext = new DefaultWorkValidationContext(documentationRegistry);
    }

    public void isolated() {
        this.isolated = true;
    }

    public WorkValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.isolated) {
            return null;
        }
        return ((ProjectInternal)this.task.getProject()).getMutationState().getAccessLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return (ProjectInternal)this.task.getProject();
    }

    @Override
    public List<? extends ResourceLock> getResourcesToLock() {
        if (this.resourceLocks == null) {
            this.resourceLocks = this.task.getSharedResources();
        }
        return this.resourceLocks;
    }

    @Override
    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public Action<? super Task> getPostAction() {
        return this.postAction;
    }

    public TaskProperties getTaskProperties() {
        return this.taskProperties;
    }

    @Override
    public void appendPostAction(Action<? super Task> action) {
        this.postAction = this.postAction.add(action);
    }

    @Override
    public Throwable getNodeFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void rethrowNodeFailure() {
        this.task.getState().rethrowFailure();
    }

    @Override
    public void prepareForExecution() {
        ((TaskContainerInternal)this.task.getProject().getTasks()).prepareForExecution(this.task);
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        for (Node targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
            processHardSuccessor.execute(targetNode);
        }
        for (Node targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskNode)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskNode)targetNode);
            processHardSuccessor.execute(targetNode);
        }
        for (Node targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor((TaskNode)targetNode);
        }
        for (Node targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    @Override
    public boolean requiresMonitoring() {
        return false;
    }

    private void addFinalizerNode(TaskNode finalizerNode) {
        this.addFinalizer(finalizerNode);
        if (!finalizerNode.isInKnownState()) {
            finalizerNode.mustNotRun();
        }
    }

    private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<Node> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<Node> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<Node> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        LocalTaskNode localTask = (LocalTaskNode)other;
        return this.task.compareTo(localTask.task);
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }

    @Override
    public void resolveMutations() {
        LocalTaskNode taskNode = this;
        TaskInternal task = this.getTask();
        MutationInfo mutations = this.getMutationInfo();
        ProjectInternal project = (ProjectInternal)task.getProject();
        ServiceRegistry serviceRegistry = project.getServices();
        FileCollectionFactory fileCollectionFactory = serviceRegistry.get(FileCollectionFactory.class);
        PropertyWalker propertyWalker = serviceRegistry.get(PropertyWalker.class);
        try {
            this.taskProperties = DefaultTaskProperties.resolve(propertyWalker, fileCollectionFactory, task);
            this.taskProperties.getOutputFileProperties().forEach(spec -> this.withDeadlockHandling(taskNode, "an output", "output property '" + spec.getPropertyName() + "'", () -> {
                File outputLocation = spec.getOutputFile();
                if (outputLocation != null) {
                    mutations.outputPaths.add(outputLocation.getAbsolutePath());
                }
                mutations.hasOutputs = true;
            }));
            this.withDeadlockHandling(taskNode, "a local state", "local state properties", () -> this.taskProperties.getLocalStateFiles().forEach(file -> {
                mutations.outputPaths.add(file.getAbsolutePath());
                mutations.hasLocalState = true;
            }));
            this.withDeadlockHandling(taskNode, "a destroyable", "destroyables", () -> this.taskProperties.getDestroyableFiles().forEach(file -> mutations.destroyablePaths.add(file.getAbsolutePath())));
            mutations.hasFileInputs = !this.taskProperties.getInputFileProperties().isEmpty();
        }
        catch (Exception e) {
            throw new TaskExecutionException(task, (Throwable)e);
        }
        mutations.resolved = true;
        if (!mutations.destroyablePaths.isEmpty()) {
            if (mutations.hasOutputs) {
                throw new IllegalStateException("Task " + taskNode + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
            }
            if (mutations.hasFileInputs) {
                throw new IllegalStateException("Task " + taskNode + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
            }
            if (mutations.hasLocalState) {
                throw new IllegalStateException("Task " + taskNode + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
            }
        }
    }

    private void withDeadlockHandling(TaskNode task, String singular, String description, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(String.format("A deadlock was detected while resolving the %s for task '%s'. This can be caused, for instance, by %s property causing dependency resolution.", description, task, singular), e);
        }
    }
}

