/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.build.BuildState;

public class TaskNodeFactory {
    private final Map<Task, TaskNode> nodes = new HashMap<Task, TaskNode>();
    private final IncludedBuildTaskGraph taskGraph;
    private final GradleInternal thisBuild;
    private final BuildIdentifier currentBuildId;
    private final DocumentationRegistry documentationRegistry;

    public TaskNodeFactory(GradleInternal thisBuild, IncludedBuildTaskGraph taskGraph) {
        this.thisBuild = thisBuild;
        this.currentBuildId = thisBuild.getServices().get(BuildState.class).getBuildIdentifier();
        this.documentationRegistry = thisBuild.getServices().get(DocumentationRegistry.class);
        this.taskGraph = taskGraph;
    }

    public Set<Task> getTasks() {
        return this.nodes.keySet();
    }

    public TaskNode getOrCreateNode(Task task) {
        TaskNode node = this.nodes.get(task);
        if (node == null) {
            node = task.getProject().getGradle() == this.thisBuild ? new LocalTaskNode((TaskInternal)task, this.documentationRegistry) : TaskInAnotherBuild.of((TaskInternal)task, this.currentBuildId, this.taskGraph);
            this.nodes.put(task, node);
        }
        return node;
    }

    public void clear() {
        this.nodes.clear();
    }
}

