/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ConfigurableClassLoaderHierarchyHasher;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.GradleVersion;

public class RegistryAwareClassLoaderHierarchyHasher
extends ConfigurableClassLoaderHierarchyHasher {
    public RegistryAwareClassLoaderHierarchyHasher(ClassLoaderRegistry registry, HashingClassLoaderFactory classLoaderFactory) {
        super(RegistryAwareClassLoaderHierarchyHasher.collectKnownClassLoaders(registry), classLoaderFactory);
    }

    private static Map<ClassLoader, String> collectKnownClassLoaders(ClassLoaderRegistry registry) {
        HashMap<ClassLoader, String> knownClassLoaders = Maps.newHashMap();
        String javaVmVersion = String.format("%s|%s", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"));
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, systemClassLoader, "system-app" + javaVmVersion);
            RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, systemClassLoader.getParent(), "system-ext" + javaVmVersion);
        }
        String gradleVersion = GradleVersion.current().getVersion();
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getRuntimeClassLoader(), "runtime:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getGradleApiClassLoader(), "gradle-api:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getGradleCoreApiClassLoader(), "gradle-core-api:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getPluginsClassLoader(), "plugins:" + gradleVersion);
        return knownClassLoaders;
    }

    private static void addClassLoader(Map<ClassLoader, String> knownClassLoaders, ClassLoader classLoader, String id) {
        if (classLoader != null) {
            knownClassLoaders.put(classLoader, id);
        }
    }
}

