/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultXcodeProject
implements XcodeProject {
    public static final String BUILD_DEBUG = "Debug";
    public static final String BUILD_RELEASE = "Release";
    public static final String TEST_DEBUG = "__GradleTestRunner_Debug";
    private final Groups groups;
    private List<XcodeTarget> targets = new ArrayList<XcodeTarget>();
    private File locationDir;

    @Inject
    public DefaultXcodeProject(ObjectFactory objectFactory) {
        this.groups = objectFactory.newInstance(Groups.class, new Object[0]);
    }

    public Groups getGroups() {
        return this.groups;
    }

    public List<XcodeTarget> getTargets() {
        return this.targets;
    }

    public Callable<List<TaskDependency>> getTaskDependencies() {
        return new Callable<List<TaskDependency>>(){

            @Override
            public List<TaskDependency> call() throws Exception {
                ArrayList<TaskDependency> result = Lists.newArrayList();
                for (XcodeTarget xcodeTarget : DefaultXcodeProject.this.getTargets()) {
                    result.addAll(xcodeTarget.getTaskDependencies());
                }
                return result;
            }
        };
    }

    public void addTarget(XcodeTarget target) {
        this.targets.add(target);
    }

    public File getLocationDir() {
        return this.locationDir;
    }

    public void setLocationDir(File locationDir) {
        this.locationDir = locationDir;
    }

    public static abstract class Groups {
        public abstract ConfigurableFileCollection getRoot();

        public abstract ConfigurableFileCollection getSources();

        public abstract ConfigurableFileCollection getTests();

        public abstract ConfigurableFileCollection getHeaders();
    }
}

