/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;

public enum FileTypes {
    MACH_O_EXECUTABLE("", "compiled.mach-o.executable"),
    MACH_O_DYNAMIC_LIBRARY("dylib", "compiled.mach-o.dylib"),
    ARCHIVE_LIBRARY("a", "archive.ar"),
    C_SOURCE_CODE("c", "sourcecode.c.c"),
    CC_SOURCE_CODE("cc", "sourcecode.cpp.cpp"),
    CPP_SOURCE_CODE("cpp", "sourcecode.cpp.cpp"),
    CXX_SOURCE_CODE("cxx", "sourcecode.cpp.cpp"),
    H_SOURCE_CODE("h", "sourcecode.c.h"),
    SWIFT_SOURCE_CODE("swift", "sourcecode.swift"),
    XCODE_PROJECT_WRAPPER("xcodeproj", "wrapper.pb-project");

    public final String fileExtension;
    public final String identifier;
    public static final ImmutableMap<String, String> FILE_EXTENSION_TO_UTI;
    public static final ImmutableMultimap<String, String> UTI_TO_FILE_EXTENSIONS;

    private FileTypes(String fileExtension, String identifier) {
        this.fileExtension = fileExtension;
        this.identifier = identifier;
    }

    static {
        Object builder = ImmutableMap.builder();
        for (FileTypes fileType : FileTypes.values()) {
            ((ImmutableMap.Builder)builder).put(fileType.fileExtension, fileType.identifier);
        }
        FILE_EXTENSION_TO_UTI = ((ImmutableMap.Builder)builder).build();
        builder = ImmutableMultimap.builder();
        for (Map.Entry entry : FILE_EXTENSION_TO_UTI.entrySet()) {
            ((ImmutableMultimap.Builder)builder).put((String)entry.getValue(), (String)entry.getKey());
        }
        UTI_TO_FILE_EXTENSIONS = ((ImmutableMultimap.Builder)builder).build();
    }
}

