/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;

public class BuildLayoutParameters {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    private static final File DEFAULT_GRADLE_USER_HOME = new File(SystemProperties.getInstance().getUserHome() + "/.gradle");
    private File gradleInstallationHomeDir;
    private File gradleUserHomeDir;
    private File projectDir;
    private File currentDir;

    public BuildLayoutParameters() {
        this(BuildLayoutParameters.findGradleInstallationHomeDir(), BuildLayoutParameters.findGradleUserHomeDir(), null, FileUtils.canonicalize(SystemProperties.getInstance().getCurrentDir()));
    }

    public BuildLayoutParameters(@Nullable File gradleInstallationHomeDir, File gradleUserHomeDir, @Nullable File projectDir, File currentDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.gradleInstallationHomeDir = gradleInstallationHomeDir;
        this.projectDir = projectDir;
        this.currentDir = currentDir;
    }

    private static File findGradleUserHomeDir() {
        String gradleUserHome = System.getProperty(GRADLE_USER_HOME_PROPERTY_KEY);
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = DEFAULT_GRADLE_USER_HOME.getAbsolutePath();
        }
        return FileUtils.canonicalize(new File(gradleUserHome));
    }

    @Nullable
    private static File findGradleInstallationHomeDir() {
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        if (gradleInstallation != null) {
            return gradleInstallation.getGradleHome();
        }
        return null;
    }

    public BuildLayoutParameters setProjectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public BuildLayoutParameters setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return this;
    }

    public BuildLayoutParameters setGradleInstallationHomeDir(@Nullable File gradleInstallationHomeDir) {
        this.gradleInstallationHomeDir = gradleInstallationHomeDir;
        return this;
    }

    public BuildLayoutParameters setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
        return this;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    @Nullable
    public File getProjectDir() {
        return this.projectDir;
    }

    public File getSearchDir() {
        return this.projectDir != null ? this.projectDir : this.currentDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    @Nullable
    public File getGradleInstallationHomeDir() {
        return this.gradleInstallationHomeDir;
    }
}

