/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildOptionBuildOperationProgressEventsEmitter;
import org.gradle.initialization.ConfigurationCache;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultGradleLauncher
implements GradleLauncher {
    private final ProjectsPreparer projectsPreparer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final BuildCompletionListener buildCompletionListener;
    private final InternalBuildFinishedListener buildFinishedListener;
    private final BuildWorkExecutor buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private final IncludedBuildControllers includedBuildControllers;
    private final GradleInternal gradle;
    private final ConfigurationCache configurationCache;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final BuildOptionBuildOperationProgressEventsEmitter buildOptionBuildOperationProgressEventsEmitter;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, ProjectsPreparer projectsPreparer2, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, BuildCompletionListener buildCompletionListener, InternalBuildFinishedListener buildFinishedListener, BuildWorkExecutor buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop, IncludedBuildControllers includedBuildControllers, SettingsPreparer settingsPreparer2, TaskExecutionPreparer taskExecutionPreparer2, ConfigurationCache configurationCache, BuildOptionBuildOperationProgressEventsEmitter buildOptionBuildOperationProgressEventsEmitter) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer2;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildFinishedListener = buildFinishedListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
        this.includedBuildControllers = includedBuildControllers;
        this.configurationCache = configurationCache;
        this.settingsPreparer = settingsPreparer2;
        this.taskExecutionPreparer = taskExecutionPreparer2;
        this.buildOptionBuildOperationProgressEventsEmitter = buildOptionBuildOperationProgressEventsEmitter;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.LoadSettings);
        return this.gradle.getSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    @Override
    public File getBuildRootDir() {
        return this.buildServices.get(BuildLayout.class).getRootDirectory();
    }

    @Override
    public GradleInternal executeTasks() {
        this.doBuildStages(Stage.RunTasks);
        return this.gradle;
    }

    @Override
    public void finishBuild() {
        if (this.stage != null) {
            this.finishBuild(this.stage.getDisplayName(), null);
        }
    }

    private void doBuildStages(Stage upTo) {
        Preconditions.checkArgument(upTo != Stage.Finished, "Stage.Finished is not supported by doBuildStages.");
        try {
            if (this.stage == null && this.gradle.isRootBuild()) {
                this.buildOptionBuildOperationProgressEventsEmitter.emit(this.gradle.getStartParameter());
            }
            if (upTo == Stage.RunTasks && this.configurationCache.canLoad()) {
                this.doConfigurationCacheBuild();
            } else {
                this.doClassicBuildStages(upTo);
            }
        }
        catch (Throwable t) {
            this.finishBuild(upTo.getDisplayName(), t);
        }
    }

    private void doClassicBuildStages(Stage upTo) {
        if (this.stage == null) {
            this.configurationCache.prepareForConfiguration();
        }
        this.prepareSettings();
        if (upTo == Stage.LoadSettings) {
            return;
        }
        this.prepareProjects();
        if (upTo == Stage.Configure) {
            return;
        }
        this.prepareTaskExecution();
        if (upTo == Stage.TaskGraph) {
            return;
        }
        this.configurationCache.save();
        this.runWork();
    }

    private void doConfigurationCacheBuild() {
        this.configurationCache.load();
        this.stage = Stage.TaskGraph;
        this.runWork();
    }

    private void finishBuild(String action, @Nullable Throwable stageFailure) {
        if (this.stage == Stage.Finished) {
            if (stageFailure != null) {
                throw this.exceptionAnalyser.transform(stageFailure);
            }
            return;
        }
        RuntimeException reportableFailure = stageFailure == null ? null : this.exceptionAnalyser.transform(stageFailure);
        BuildResult buildResult = new BuildResult(action, this.gradle, reportableFailure);
        ArrayList<? extends Throwable> failures = new ArrayList<Throwable>();
        this.includedBuildControllers.finishBuild(failures);
        try {
            this.buildListener.buildFinished(buildResult);
            this.buildFinishedListener.buildFinished((GradleInternal)buildResult.getGradle(), buildResult.getFailure() != null);
        }
        catch (Throwable t) {
            failures.add(t);
        }
        this.stage = Stage.Finished;
        if (failures.isEmpty() && reportableFailure != null) {
            throw reportableFailure;
        }
        if (!failures.isEmpty()) {
            if (stageFailure instanceof MultipleBuildFailures) {
                failures.addAll(0, ((MultipleBuildFailures)stageFailure).getCauses());
            } else if (stageFailure != null) {
                failures.add(0, stageFailure);
            }
            throw this.exceptionAnalyser.transform(new MultipleBuildFailures(failures));
        }
    }

    private void prepareSettings() {
        if (this.stage == null) {
            this.settingsPreparer.prepareSettings(this.gradle);
            this.stage = Stage.LoadSettings;
        }
    }

    private void prepareProjects() {
        if (this.stage == Stage.LoadSettings) {
            this.projectsPreparer.prepareProjects(this.gradle);
            this.stage = Stage.Configure;
        }
    }

    private void prepareTaskExecution() {
        if (this.stage == Stage.Configure) {
            this.taskExecutionPreparer.prepareForTaskExecution(this.gradle);
            this.stage = Stage.TaskGraph;
        }
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        boolean added = this.getConfiguredBuild().getStartParameter().addTaskNames(taskPaths);
        if (!added) {
            return;
        }
        this.reevaluateTaskGraph();
    }

    private void reevaluateTaskGraph() {
        this.stage = Stage.Configure;
        this.doBuildStages(Stage.TaskGraph);
    }

    private void runWork() {
        if (this.stage != Stage.TaskGraph) {
            throw new IllegalStateException("Cannot execute tasks: current stage = " + (Object)((Object)this.stage));
        }
        ArrayList taskFailures = new ArrayList();
        this.buildExecuter.execute(this.gradle, taskFailures);
        if (!taskFailures.isEmpty()) {
            throw new MultipleBuildFailures(taskFailures);
        }
        this.stage = Stage.RunTasks;
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.buildServices).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private static enum Stage {
        LoadSettings,
        Configure,
        TaskGraph,
        RunTasks{

            @Override
            String getDisplayName() {
                return "Build";
            }
        }
        ,
        Finished;


        String getDisplayName() {
            return this.name();
        }
    }
}

