/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Set;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class LegacyConfigurationsSupplier
implements Supplier<ImmutableList<? extends ConfigurationMetadata>> {
    private final ComponentResolveMetadata targetComponent;

    public LegacyConfigurationsSupplier(ComponentResolveMetadata targetComponent) {
        this.targetComponent = targetComponent;
    }

    @Override
    public ImmutableList<? extends ConfigurationMetadata> get() {
        Set<String> configurationNames = this.targetComponent.getConfigurationNames();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String configurationName : configurationNames) {
            ConfigurationMetadata configuration = this.targetComponent.getConfiguration(configurationName);
            if (!configuration.isCanBeConsumed()) continue;
            builder.add(configuration);
        }
        return builder.build();
    }
}

