/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class AbstractConfigurationMetadata
implements ModuleConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final String name;
    private final ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts;
    private final boolean transitive;
    private final boolean visible;
    private final ImmutableSet<String> hierarchy;
    private final ImmutableList<ExcludeMetadata> excludes;
    private final ImmutableAttributes attributes;
    private final ImmutableCapabilities capabilities;
    private final boolean mavenArtifactDiscovery;
    private final boolean externalVariant;
    private ImmutableList<ModuleDependencyMetadata> configDependencies;
    private Factory<List<ModuleDependencyMetadata>> configDependenciesFactory;

    AbstractConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts2, ImmutableSet<String> hierarchy, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, ImmutableList<ModuleDependencyMetadata> configDependencies, ImmutableCapabilities capabilities, boolean mavenArtifactDiscovery, boolean externalVariant) {
        this.componentId = componentId;
        this.name = name;
        this.transitive = transitive;
        this.visible = visible;
        this.artifacts = artifacts2;
        this.hierarchy = hierarchy;
        this.excludes = excludes;
        this.attributes = attributes;
        this.configDependencies = configDependencies;
        this.capabilities = capabilities;
        this.mavenArtifactDiscovery = mavenArtifactDiscovery;
        this.externalVariant = externalVariant;
    }

    AbstractConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts2, ImmutableSet<String> hierarchy, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, Factory<List<ModuleDependencyMetadata>> configDependenciesFactory, ImmutableCapabilities capabilities, boolean mavenArtifactDiscovery, boolean externalVariant) {
        this.componentId = componentId;
        this.name = name;
        this.transitive = transitive;
        this.visible = visible;
        this.artifacts = artifacts2;
        this.hierarchy = hierarchy;
        this.excludes = excludes;
        this.attributes = attributes;
        this.configDependenciesFactory = configDependenciesFactory;
        this.capabilities = capabilities;
        this.mavenArtifactDiscovery = mavenArtifactDiscovery;
        this.externalVariant = externalVariant;
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of(this.componentId, "configuration", this.name);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VariantResolveMetadata.Identifier getIdentifier() {
        return null;
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public List<String> getConsumptionAlternatives() {
        return null;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public boolean isExternalVariant() {
        return this.externalVariant;
    }

    public void setDependencies(List<ModuleDependencyMetadata> dependencies) {
        assert (this.configDependencies == null);
        this.configDependencies = ImmutableList.copyOf(dependencies);
    }

    public void setConfigDependenciesFactory(Factory<List<ModuleDependencyMetadata>> dependenciesFactory) {
        assert (this.configDependencies == null);
        assert (this.configDependenciesFactory == null);
        this.configDependenciesFactory = dependenciesFactory;
    }

    public ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Set<? extends VariantResolveMetadata> getVariants() {
        return ImmutableSet.of(new DefaultVariantMetadata(this.name, null, this.asDescribable(), this.getAttributes(), this.getArtifacts(), this.getCapabilities()));
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean requiresMavenArtifactDiscovery() {
        return this.mavenArtifactDiscovery;
    }

    ImmutableList<ModuleDependencyMetadata> getConfigDependencies() {
        if (this.configDependenciesFactory != null) {
            this.configDependencies = ImmutableList.copyOf((Collection)this.configDependenciesFactory.create());
            this.configDependenciesFactory = null;
        }
        return this.configDependencies;
    }

    protected ModuleComponentIdentifier getComponentId() {
        return this.componentId;
    }
}

