/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class PreferJavaRuntimeVariant
extends EmptySchema {
    private static final Set<Attribute<?>> SUPPORTED_ATTRIBUTES = Sets.newHashSet(Usage.USAGE_ATTRIBUTE, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
    private final PreferRuntimeVariantUsageDisambiguationRule usageDisambiguationRule;
    private final PreferJarVariantUsageDisambiguationRule formatDisambiguationRule;

    public PreferJavaRuntimeVariant(NamedObjectInstantiator instantiator) {
        Usage runtimeUsage = instantiator.named(Usage.class, "java-runtime");
        LibraryElements jarLibraryElements = instantiator.named(LibraryElements.class, "jar");
        this.usageDisambiguationRule = new PreferRuntimeVariantUsageDisambiguationRule(runtimeUsage);
        this.formatDisambiguationRule = new PreferJarVariantUsageDisambiguationRule(jarLibraryElements);
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return SUPPORTED_ATTRIBUTES;
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        if (Usage.USAGE_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast(this.usageDisambiguationRule);
        }
        if (LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast(this.formatDisambiguationRule);
        }
        return super.disambiguationRules(attribute);
    }

    private static class PreferJarVariantUsageDisambiguationRule
    implements DisambiguationRule<LibraryElements> {
        private final LibraryElements jarLibraryElements;

        public PreferJarVariantUsageDisambiguationRule(LibraryElements jarLibraryElements) {
            this.jarLibraryElements = jarLibraryElements;
        }

        @Override
        public boolean doesSomething() {
            return true;
        }

        @Override
        public void execute(MultipleCandidatesResult<LibraryElements> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.jarLibraryElements)) {
                details.closestMatch(this.jarLibraryElements);
            }
        }
    }

    private static class PreferRuntimeVariantUsageDisambiguationRule
    implements DisambiguationRule<Usage> {
        private final Usage runtimeUsage;

        public PreferRuntimeVariantUsageDisambiguationRule(Usage runtimeUsage) {
            this.runtimeUsage = runtimeUsage;
        }

        @Override
        public boolean doesSomething() {
            return true;
        }

        @Override
        public void execute(MultipleCandidatesResult<Usage> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.runtimeUsage)) {
                details.closestMatch(this.runtimeUsage);
            }
        }
    }
}

