/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AdditionalVariant;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class RealisedMavenModuleResolveMetadata
extends AbstractRealisedModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    private final NamedObjectInstantiator objectInstantiator;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private final ImmutableList<? extends ConfigurationMetadata> derivedVariants;

    public static RealisedMavenModuleResolveMetadata transform(DefaultMavenModuleResolveMetadata metadata) {
        Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants;
        VariantMetadataRules variantMetadataRules = metadata.getVariantMetadataRules();
        ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> variants = LazyToRealisedModuleComponentResolveMetadataHelper.realiseVariants(metadata, variantMetadataRules, metadata.getVariants());
        HashMap<String, ConfigurationMetadata> configurations = Maps.newHashMapWithExpectedSize(metadata.getConfigurationNames().size());
        List<ConfigurationMetadata> derivedVariants = ImmutableList.of();
        if (variants.isEmpty() && (maybeDeriveVariants = metadata.maybeDeriveVariants()).isPresent()) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (ConfigurationMetadata configurationMetadata : maybeDeriveVariants.get()) {
                ImmutableList dependencies = (ImmutableList)Cast.uncheckedCast(configurationMetadata.getDependencies());
                RealisedConfigurationMetadata derivedVariantMetadata = new RealisedConfigurationMetadata(metadata.getId(), configurationMetadata.getName(), configurationMetadata.isTransitive(), configurationMetadata.isVisible(), configurationMetadata.getHierarchy(), (ImmutableList)Cast.uncheckedCast(configurationMetadata.getArtifacts()), configurationMetadata.getExcludes(), configurationMetadata.getAttributes(), (ImmutableCapabilities)configurationMetadata.getCapabilities(), configurationMetadata.requiresMavenArtifactDiscovery(), dependencies, false, configurationMetadata.isExternalVariant());
                builder.add(derivedVariantMetadata);
            }
            derivedVariants = RealisedMavenModuleResolveMetadata.addVariantsFromRules(metadata, (ImmutableList<ConfigurationMetadata>)builder.build(), variantMetadataRules);
        }
        for (String configurationName : metadata.getConfigurationNames()) {
            configurations.put(configurationName, RealisedMavenModuleResolveMetadata.createConfiguration(metadata, configurationName));
        }
        return new RealisedMavenModuleResolveMetadata(metadata, variants, derivedVariants, configurations);
    }

    private static List<ConfigurationMetadata> addVariantsFromRules(ModuleComponentResolveMetadata componentMetadata, ImmutableList<ConfigurationMetadata> derivedVariants, VariantMetadataRules variantMetadataRules) {
        List<AdditionalVariant> additionalVariants = variantMetadataRules.getAdditionalVariants();
        if (additionalVariants.isEmpty()) {
            return derivedVariants;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(derivedVariants);
        Map variantsByName = derivedVariants.stream().collect(Collectors.toMap(ConfigurationMetadata::getName, Function.identity()));
        for (AdditionalVariant additionalVariant : additionalVariants) {
            ImmutableList artifacts2;
            List<Object> dependencies;
            ImmutableCapabilities capabilities;
            ImmutableAttributes attributes;
            String name = additionalVariant.getName();
            String baseName = additionalVariant.getBase();
            ConfigurationMetadata baseConf = (ConfigurationMetadata)variantsByName.get(baseName);
            if (baseConf == null) {
                attributes = componentMetadata.getAttributes();
                capabilities = ImmutableCapabilities.EMPTY;
                dependencies = ImmutableList.of();
                artifacts2 = ImmutableList.of();
            } else {
                attributes = baseConf.getAttributes();
                capabilities = (ImmutableCapabilities)baseConf.getCapabilities();
                dependencies = ((ModuleConfigurationMetadata)baseConf).getDependencies();
                artifacts2 = (ImmutableList)Cast.uncheckedCast(baseConf.getArtifacts());
            }
            if (baseName == null || baseConf != null) {
                builder.add(RealisedMavenModuleResolveMetadata.applyRules(componentMetadata.getId(), name, variantMetadataRules, attributes, capabilities, dependencies, artifacts2, true, true, ImmutableSet.of(), true, false));
                continue;
            }
            if (additionalVariant.isLenient()) continue;
            throw new InvalidUserDataException("Variant '" + baseName + "' not defined in module " + componentMetadata.getId().getDisplayName());
        }
        return builder.build();
    }

    private static RealisedConfigurationMetadata applyRules(ModuleComponentIdentifier id, String configurationName, VariantMetadataRules variantMetadataRules, ImmutableAttributes attributes, ImmutableCapabilities capabilities, List<? extends ModuleDependencyMetadata> dependencies, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts2, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, boolean addedByRule, boolean isExternalVariant) {
        AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata variant = new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(configurationName);
        ImmutableAttributes variantAttributes = variantMetadataRules.applyVariantAttributeRules(variant, attributes);
        CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, capabilities);
        List<? extends ModuleDependencyMetadata> dependenciesMetadata = variantMetadataRules.applyDependencyMetadataRules(variant, dependencies);
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifactsMetadata = variantMetadataRules.applyVariantFilesMetadataRulesToArtifacts(variant, artifacts2, id);
        boolean mavenArtifactDiscovery = artifactsMetadata == artifacts2;
        return RealisedMavenModuleResolveMetadata.createConfiguration(id, configurationName, transitive, visible, hierarchy, artifactsMetadata, dependenciesMetadata, variantAttributes, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()), mavenArtifactDiscovery, addedByRule, isExternalVariant);
    }

    private static RealisedConfigurationMetadata createConfiguration(DefaultMavenModuleResolveMetadata metadata, String configurationName) {
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        Configuration configuration = metadata.getConfigurationDefinitions().get(configurationName);
        ImmutableSet<String> hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
        return RealisedMavenModuleResolveMetadata.createConfiguration(metadata.getId(), configurationName, configuration.isTransitive(), configuration.isVisible(), hierarchy, RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(metadata, configurationName), ((ModuleConfigurationMetadata)metadata.getConfiguration(configurationName)).getDependencies(), metadata.getAttributes(), ImmutableCapabilities.EMPTY, true, false, metadata.isExternalVariant());
    }

    private static RealisedConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts2, List<? extends DependencyMetadata> dependencies, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean mavenArtifactDiscovery, boolean addedByRule, boolean isExternalVariant) {
        ImmutableList<ModuleDependencyMetadata> asImmutable = ImmutableList.copyOf((Collection)Cast.uncheckedCast(dependencies));
        return new RealisedConfigurationMetadata(componentId, name, transitive, visible, hierarchy, artifacts2, ImmutableList.of(), attributes, capabilities, mavenArtifactDiscovery, asImmutable, addedByRule, isExternalVariant);
    }

    static ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration(DefaultMavenModuleResolveMetadata metadata, String name) {
        ImmutableList<Object> artifacts2;
        if (name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test")) {
            String type = metadata.isKnownJarPackaging() ? "jar" : metadata.getPackaging();
            artifacts2 = ImmutableList.of(new DefaultModuleComponentArtifactMetadata(metadata.getId(), new DefaultIvyArtifactName(metadata.getId().getModule(), type, type)));
        } else {
            artifacts2 = ImmutableList.of();
        }
        return artifacts2;
    }

    private static ImmutableList<ModuleDependencyMetadata> filterDependencies(ModuleComponentIdentifier componentId, ConfigurationMetadata config, ImmutableList<MavenDependencyDescriptor> dependencies) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        for (MavenDependencyDescriptor dependency : dependencies) {
            if (isOptionalConfiguration && RealisedMavenModuleResolveMetadata.includeInOptionalConfiguration(dependency)) {
                filteredDependencies.add(new DefaultMavenModuleResolveMetadata.OptionalConfigurationDependencyMetadata(config, componentId, dependency));
                continue;
            }
            if (!RealisedMavenModuleResolveMetadata.include(dependency, config.getHierarchy())) continue;
            filteredDependencies.add(RealisedMavenModuleResolveMetadata.contextualize(config, componentId, dependency));
        }
        return filteredDependencies.build();
    }

    static ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, MavenDependencyDescriptor incoming) {
        ConfigurationBoundExternalDependencyMetadata dependency = new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
        dependency.alwaysUseAttributeMatching();
        return dependency;
    }

    private static boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private static boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy) {
        MavenScope dependencyScope = dependency.getScope();
        if (dependency.isOptional()) {
            return false;
        }
        return hierarchy.contains(dependencyScope.getLowerName());
    }

    RealisedMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants, List<ConfigurationMetadata> derivedVariants, Map<String, ConfigurationMetadata> configurations) {
        super((AbstractModuleComponentResolveMetadata)metadata, variants, configurations);
        this.objectInstantiator = metadata.getObjectInstantiator();
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
        this.derivedVariants = ImmutableList.copyOf(derivedVariants);
    }

    private RealisedMavenModuleResolveMetadata(RealisedMavenModuleResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        super(metadata, sources, derivationStrategy);
        this.objectInstantiator = metadata.objectInstantiator;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.derivedVariants = metadata.derivedVariants;
    }

    @Override
    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.of(this.getDerivedVariants());
    }

    ImmutableList<? extends ConfigurationMetadata> getDerivedVariants() {
        return this.derivedVariants;
    }

    @Override
    public RealisedMavenModuleResolveMetadata withSources(ModuleSources sources) {
        return new RealisedMavenModuleResolveMetadata(this, sources, this.getVariantDerivationStrategy());
    }

    @Override
    public ModuleComponentResolveMetadata withDerivationStrategy(VariantDerivationStrategy derivationStrategy) {
        if (this.getVariantDerivationStrategy() == derivationStrategy) {
            return this;
        }
        return new RealisedMavenModuleResolveMetadata(this, this.getSources(), derivationStrategy);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this, this.objectInstantiator);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealisedMavenModuleResolveMetadata that = (RealisedMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal(this.packaging, that.packaging) && Objects.equal(this.snapshotTimestamp, that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp);
    }
}

