/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;

public class StyledException
extends GradleException {
    private static final Logger LOGGER = Logging.getLogger(StyledException.class);
    private static final Pattern STYLES_REGEX = Pattern.compile("<([A-Za-z]+)>(?:<([A-Za-z]+)>)*(.*?)(?:</\\2>)*</\\1>");
    private final String styledMessage;

    public StyledException() {
        this.styledMessage = "";
    }

    public StyledException(String message2) {
        super(StyledException.unstyled(message2));
        this.styledMessage = message2;
    }

    private static String unstyled(String message2) {
        Matcher matcher = STYLES_REGEX.matcher(message2);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, "$3");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public StyledException(String message2, @Nullable Throwable cause) {
        super(StyledException.unstyled(message2), cause);
        this.styledMessage = message2;
    }

    public static String style(StyledTextOutput.Style style, String text) {
        if (text == null) {
            return null;
        }
        return "<" + (Object)((Object)style) + ">" + text + "</" + (Object)((Object)style) + ">";
    }

    public void render(StyledTextOutput output) {
        Matcher matcher = STYLES_REGEX.matcher(this.styledMessage);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            buf.setLength(0);
            matcher.appendReplacement(buf, "");
            output.text(buf);
            String styleText = matcher.group(1);
            String txt = matcher.group(3);
            StyledTextOutput.Style style = StyledException.toStyle(styleText);
            output.withStyle(style).text(txt);
        }
        buf.setLength(0);
        matcher.appendTail(buf);
        output.text(buf.toString());
    }

    private static StyledTextOutput.Style toStyle(String styleText) {
        try {
            return StyledTextOutput.Style.valueOf(StringUtils.capitalize(styleText));
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Style '{}' doesn't exist", (Object)styleText);
            return StyledTextOutput.Style.Normal;
        }
    }
}

