/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public interface UnitOfWork
extends Describable {
    public Identity identify(Map<String, ValueSnapshot> var1, Map<String, CurrentFileCollectionFingerprint> var2);

    public WorkOutput execute(ExecutionRequest var1);

    default public Object loadRestoredOutput(File workspace) {
        throw new UnsupportedOperationException();
    }

    public WorkspaceProvider getWorkspaceProvider();

    default public Optional<Duration> getTimeout() {
        return Optional.empty();
    }

    default public InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
        return InputChangeTrackingStrategy.NONE;
    }

    default public void visitImplementations(ImplementationVisitor visitor) {
        visitor.visitImplementation(this.getClass());
    }

    public void visitInputs(InputVisitor var1);

    public void visitOutputs(File var1, OutputVisitor var2);

    default public long markExecutionTime() {
        return 0L;
    }

    default public void validate(WorkValidationContext validationContext) {
    }

    default public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return Optional.empty();
    }

    default public Optional<ExecutionOutcome> skipIfInputsEmpty(ImmutableSortedMap<String, FileSystemSnapshot> outputFilesAfterPreviousExecution) {
        return Optional.empty();
    }

    default public boolean isAllowedToLoadFromCache() {
        return true;
    }

    default public OverlappingOutputHandling getOverlappingOutputHandling() {
        return OverlappingOutputHandling.IGNORE_OVERLAPS;
    }

    default public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
        return true;
    }

    default public void markLegacySnapshottingInputsStarted() {
    }

    default public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
    }

    default public void ensureLegacySnapshottingInputsClosed() {
    }

    public static enum InputChangeTrackingStrategy {
        NONE(false),
        INCREMENTAL_PARAMETERS(true),
        ALL_PARAMETERS(true);

        private final boolean requiresInputChanges;

        private InputChangeTrackingStrategy(boolean requiresInputChanges) {
            this.requiresInputChanges = requiresInputChanges;
        }

        public boolean requiresInputChanges() {
            return this.requiresInputChanges;
        }
    }

    public static enum OverlappingOutputHandling {
        DETECT_OVERLAPS,
        IGNORE_OVERLAPS;

    }

    public static interface OutputVisitor {
        default public void visitOutputProperty(String propertyName, TreeType type, File root, FileCollection contents) {
        }

        default public void visitLocalState(File localStateRoot) {
        }

        default public void visitDestroyable(File destroyableRoot) {
        }
    }

    public static enum IdentityKind {
        NON_IDENTITY,
        IDENTITY;

    }

    public static enum InputPropertyType {
        NON_INCREMENTAL(false, false),
        INCREMENTAL(true, false),
        PRIMARY(true, true);

        private final boolean incremental;
        private final boolean skipWhenEmpty;

        private InputPropertyType(boolean incremental, boolean skipWhenEmpty) {
            this.incremental = incremental;
            this.skipWhenEmpty = skipWhenEmpty;
        }

        public boolean isIncremental() {
            return this.incremental;
        }

        public boolean isSkipWhenEmpty() {
            return this.skipWhenEmpty;
        }
    }

    public static interface ValueSupplier {
        @Nullable
        public Object getValue();
    }

    public static interface InputVisitor {
        default public void visitInputProperty(String propertyName, IdentityKind identity, ValueSupplier value) {
        }

        default public void visitInputFileProperty(String propertyName, InputPropertyType type, IdentityKind identity, @Nullable Object value, Supplier<CurrentFileCollectionFingerprint> fingerprinter) {
        }
    }

    public static interface ImplementationVisitor {
        public void visitImplementation(Class<?> var1);

        public void visitImplementation(ImplementationSnapshot var1);
    }

    public static enum WorkResult {
        DID_WORK,
        DID_NO_WORK;

    }

    public static interface WorkOutput {
        public WorkResult getDidWork();

        public Object getOutput();
    }

    public static interface ExecutionRequest {
        public File getWorkspace();

        public Optional<InputChangesInternal> getInputChanges();

        public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs();
    }

    public static interface Identity {
        public String getUniqueId();
    }
}

