/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.logging.text.TreeFormatter;

@Contextual
public class WorkValidationException
extends GradleException {
    private final List<String> problems;

    private WorkValidationException(String message2, Collection<String> problems) {
        super(message2);
        this.problems = ImmutableList.copyOf(problems);
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public static Builder forProblems(Collection<String> problems) {
        return new Builder(problems);
    }

    public static class BuilderWithSummary {
        private final List<String> problems;
        private final String summary;

        public BuilderWithSummary(List<String> problems, String summary) {
            this.problems = problems;
            this.summary = summary;
        }

        public WorkValidationException get() {
            return this.build(null);
        }

        public WorkValidationException getWithExplanation(String explanation) {
            return this.build(explanation);
        }

        private WorkValidationException build(@Nullable String explanation) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.summary);
            formatter.startChildren();
            for (String problem : this.problems) {
                formatter.node(problem);
            }
            formatter.endChildren();
            if (explanation != null) {
                formatter.node(explanation);
            }
            return new WorkValidationException(formatter.toString(), ImmutableList.copyOf(this.problems));
        }
    }

    public static class Builder {
        private final List<String> problems;
        private final int size;

        public Builder(Collection<String> problems) {
            this.problems = ImmutableList.copyOf(problems);
            this.size = problems.size();
        }

        public Builder limitTo(int maxProblems) {
            return new Builder(this.problems.stream().limit(maxProblems).collect(Collectors.toList()));
        }

        public BuilderWithSummary withSummary(Function<SummaryHelper, String> summaryBuilder) {
            return new BuilderWithSummary(this.problems, summaryBuilder.apply(new SummaryHelper()));
        }

        public class SummaryHelper {
            public int size() {
                return Builder.this.size;
            }

            public String pluralize(String term) {
                if (Builder.this.size > 1) {
                    return term + "s";
                }
                return term;
            }
        }
    }
}

