/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.SortedMap;
import org.gradle.internal.execution.history.changes.AbsolutePathFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.ClasspathCompareStrategy;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.IgnoredPathCompareStrategy;
import org.gradle.internal.execution.history.changes.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.PropertyDiffListener;
import org.gradle.internal.execution.history.changes.SortedMapDiffUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

public abstract class AbstractFingerprintChanges
implements ChangeContainer {
    private static final ImmutableMap<String, FingerprintCompareStrategy> COMPARE_STRATEGY_MAPPING = ImmutableMap.builder().put("ABSOLUTE_PATH", AbsolutePathFingerprintCompareStrategy.INSTANCE).put("NAME_ONLY", NormalizedPathFingerprintCompareStrategy.INSTANCE).put("RELATIVE_PATH", NormalizedPathFingerprintCompareStrategy.INSTANCE).put("IGNORED_PATH", IgnoredPathCompareStrategy.INSTANCE).put("CLASSPATH", ClasspathCompareStrategy.INSTANCE).put("COMPILE_CLASSPATH", ClasspathCompareStrategy.INSTANCE).build();
    protected final SortedMap<String, FileCollectionFingerprint> previous;
    protected final SortedMap<String, CurrentFileCollectionFingerprint> current;
    private final String title;

    protected AbstractFingerprintChanges(SortedMap<String, FileCollectionFingerprint> previous, SortedMap<String, CurrentFileCollectionFingerprint> current, String title) {
        this.previous = previous;
        this.current = current;
        this.title = title;
    }

    @Override
    public boolean accept(final ChangeVisitor visitor) {
        return SortedMapDiffUtil.diff(this.previous, this.current, new PropertyDiffListener<String, FileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            @Override
            public boolean removed(String previousProperty) {
                return true;
            }

            @Override
            public boolean added(String currentProperty) {
                return true;
            }

            @Override
            public boolean updated(String property, FileCollectionFingerprint previousFingerprint, CurrentFileCollectionFingerprint currentFingerprint) {
                String propertyTitle = AbstractFingerprintChanges.this.title + " property '" + property + "'";
                FingerprintCompareStrategy compareStrategy = AbstractFingerprintChanges.this.determineCompareStrategy(currentFingerprint);
                return compareStrategy.visitChangesSince(previousFingerprint, currentFingerprint, propertyTitle, visitor);
            }
        });
    }

    protected FingerprintCompareStrategy determineCompareStrategy(CurrentFileCollectionFingerprint currentFingerprint) {
        return COMPARE_STRATEGY_MAPPING.get(currentFingerprint.getStrategyIdentifier());
    }
}

