/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.Describable;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.CachingChangeContainer;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.ErrorHandlingChangeContainer;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ImplementationChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.InputValueChanges;
import org.gradle.internal.execution.history.changes.NonIncrementalInputChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.history.changes.PreviousSuccessChanges;
import org.gradle.internal.execution.history.changes.PropertyChanges;
import org.gradle.internal.execution.history.changes.RebuildExecutionStateChanges;
import org.gradle.internal.execution.history.changes.SummarizingChangeContainer;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class DefaultExecutionStateChangeDetector
implements ExecutionStateChangeDetector {
    @Override
    public ExecutionStateChanges detectChanges(AfterPreviousExecutionState lastExecution, BeforeExecutionState thisExecution, Describable executable, IncrementalInputProperties incrementalInputProperties) {
        PreviousSuccessChanges previousSuccessState = new PreviousSuccessChanges(lastExecution.isSuccessful());
        ImplementationChanges implementationChanges = new ImplementationChanges(lastExecution.getImplementation(), lastExecution.getAdditionalImplementations(), thisExecution.getImplementation(), thisExecution.getAdditionalImplementations(), executable);
        PropertyChanges inputPropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputProperties().keySet(), "Input", executable);
        InputValueChanges inputPropertyValueChanges = new InputValueChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), executable);
        PropertyChanges inputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputFileProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputFileProperties().keySet(), "Input file", executable);
        InputFileChanges nonIncrementalInputFileChanges = incrementalInputProperties.nonIncrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        PropertyChanges outputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getOutputFilesProducedByWork().keySet(), (ImmutableSortedSet<String>)thisExecution.getOutputFileLocationSnapshots().keySet(), "Output", executable);
        ImmutableSortedMap<String, FileSystemSnapshot> remainingPreviouslyProducedOutputs = thisExecution.getDetectedOverlappingOutputs().isPresent() ? OutputSnapshotUtil.findOutputsStillPresentSincePreviousExecution(lastExecution.getOutputFilesProducedByWork(), thisExecution.getOutputFileLocationSnapshots()) : thisExecution.getOutputFileLocationSnapshots();
        OutputFileChanges outputFileChanges = new OutputFileChanges(lastExecution.getOutputFilesProducedByWork(), remainingPreviouslyProducedOutputs);
        ChangeContainer rebuildTriggeringChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, new SummarizingChangeContainer(previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, nonIncrementalInputFileChanges));
        ImmutableList<String> rebuildReasons = DefaultExecutionStateChangeDetector.collectChanges(rebuildTriggeringChanges);
        if (!rebuildReasons.isEmpty()) {
            return new NonIncrementalDetectedExecutionStateChanges(rebuildReasons, thisExecution.getInputFileProperties(), incrementalInputProperties);
        }
        InputFileChanges directIncrementalInputFileChanges = incrementalInputProperties.incrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        InputFileChanges incrementalInputFileChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, DefaultExecutionStateChangeDetector.caching(directIncrementalInputFileChanges));
        ImmutableList<String> incrementalInputFileChangeMessages = DefaultExecutionStateChangeDetector.collectChanges(incrementalInputFileChanges);
        return new IncrementalDetectedExecutionStateChanges(incrementalInputFileChangeMessages, thisExecution.getInputFileProperties(), incrementalInputFileChanges, incrementalInputProperties);
    }

    private static ImmutableList<String> collectChanges(ChangeContainer changes) {
        ImmutableList.Builder<String> builder = ImmutableList.builder();
        MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor(builder, 3);
        changes.accept(visitor);
        return builder.build();
    }

    private static InputFileChanges caching(InputFileChanges wrapped) {
        CachingChangeContainer cachingChangeContainer = new CachingChangeContainer(3, wrapped);
        return new InputFileChangesWrapper(wrapped, cachingChangeContainer);
    }

    private static ChangeContainer errorHandling(Describable executable, ChangeContainer wrapped) {
        return new ErrorHandlingChangeContainer(executable, wrapped);
    }

    private static InputFileChanges errorHandling(Describable executable, InputFileChanges wrapped) {
        ErrorHandlingChangeContainer errorHandlingChangeContainer = new ErrorHandlingChangeContainer(executable, wrapped);
        return new InputFileChangesWrapper(wrapped, errorHandlingChangeContainer);
    }

    private static class MessageCollectingChangeVisitor
    implements ChangeVisitor {
        private final ImmutableCollection.Builder<String> messages;
        private final int max;
        private int count;

        public MessageCollectingChangeVisitor(ImmutableCollection.Builder<String> messages, int max) {
            this.messages = messages;
            this.max = max;
        }

        @Override
        public boolean visitChange(Change change) {
            this.messages.add(change.getMessage());
            return ++this.count < this.max;
        }
    }

    private static abstract class AbstractDetectedExecutionStateChanges
    implements ExecutionStateChanges {
        private final ImmutableList<String> allChangeMessages;
        protected final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties;
        protected final IncrementalInputProperties incrementalInputProperties;

        public AbstractDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> incrementalInputFileProperties, IncrementalInputProperties incrementalInputProperties) {
            this.allChangeMessages = allChangeMessages;
            this.inputFileProperties = incrementalInputFileProperties;
            this.incrementalInputProperties = incrementalInputProperties;
        }

        @Override
        public ImmutableList<String> getAllChangeMessages() {
            return this.allChangeMessages;
        }

        @Override
        public ExecutionStateChanges withEnforcedRebuild(String rebuildReason) {
            return new RebuildExecutionStateChanges(rebuildReason, this.inputFileProperties, this.incrementalInputProperties);
        }
    }

    private static class NonIncrementalDetectedExecutionStateChanges
    extends AbstractDetectedExecutionStateChanges {
        public NonIncrementalDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, IncrementalInputProperties incrementalInputProperties) {
            super(allChangeMessages, inputFileProperties, incrementalInputProperties);
        }

        @Override
        public InputChangesInternal createInputChanges() {
            return new NonIncrementalInputChanges(this.inputFileProperties, this.incrementalInputProperties);
        }
    }

    private static class IncrementalDetectedExecutionStateChanges
    extends AbstractDetectedExecutionStateChanges {
        private final InputFileChanges inputFileChanges;

        public IncrementalDetectedExecutionStateChanges(ImmutableList<String> allChangeMessages, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, InputFileChanges incrementalInputFileChanges, IncrementalInputProperties incrementalInputProperties) {
            super(allChangeMessages, inputFileProperties, incrementalInputProperties);
            this.inputFileChanges = incrementalInputFileChanges;
        }

        @Override
        public InputChangesInternal createInputChanges() {
            return new IncrementalInputChanges(this.inputFileChanges, this.incrementalInputProperties);
        }
    }

    private static class InputFileChangesWrapper
    implements InputFileChanges {
        private final InputFileChanges inputFileChangesDelegate;
        private final ChangeContainer changeContainerDelegate;

        public InputFileChangesWrapper(InputFileChanges inputFileChangesDelegate, ChangeContainer changeContainerDelegate) {
            this.inputFileChangesDelegate = inputFileChangesDelegate;
            this.changeContainerDelegate = changeContainerDelegate;
        }

        @Override
        public boolean accept(String propertyName, ChangeVisitor visitor) {
            return this.inputFileChangesDelegate.accept(propertyName, visitor);
        }

        @Override
        public boolean accept(ChangeVisitor visitor) {
            return this.changeContainerDelegate.accept(visitor);
        }
    }
}

