/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.history.changes.DefaultInputFileChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableBiMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultIncrementalInputProperties
implements IncrementalInputProperties {
    private final ImmutableBiMap<String, Object> incrementalInputProperties;

    public DefaultIncrementalInputProperties(ImmutableBiMap<String, Object> incrementalInputProperties) {
        this.incrementalInputProperties = incrementalInputProperties;
    }

    @Override
    public String getPropertyNameFor(Object propertyValue) {
        String propertyName = (String)((ImmutableMap)((Object)this.incrementalInputProperties.inverse())).get(propertyValue);
        if (propertyName == null) {
            throw new InvalidUserDataException("Cannot query incremental changes: No property found for value " + propertyValue + ". Incremental properties: " + Joiner.on(", ").join(this.incrementalInputProperties.keySet()) + ".");
        }
        return propertyName;
    }

    @Override
    public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        return new DefaultInputFileChanges(Maps.filterKeys(previous, propertyName -> !this.incrementalInputProperties.containsKey(propertyName)), Maps.filterKeys(current, propertyName -> !this.incrementalInputProperties.containsKey(propertyName)));
    }

    @Override
    public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        return new DefaultInputFileChanges(ImmutableSortedMap.copyOfSorted(Maps.filterKeys(previous, propertyName -> this.incrementalInputProperties.containsKey(propertyName))), ImmutableSortedMap.copyOfSorted(Maps.filterKeys(current, propertyName -> this.incrementalInputProperties.containsKey(propertyName))));
    }
}

