/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.history.changes.DefaultInputFileChanges;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public interface IncrementalInputProperties {
    public static final IncrementalInputProperties NONE = new IncrementalInputProperties(){

        @Override
        public String getPropertyNameFor(Object value) {
            throw new InvalidUserDataException("Cannot query incremental changes for property " + value + ": No incremental properties declared.");
        }

        @Override
        public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return new DefaultInputFileChanges(previous, current);
        }

        @Override
        public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return InputFileChanges.EMPTY;
        }
    };
    public static final IncrementalInputProperties ALL = new IncrementalInputProperties(){

        @Override
        public String getPropertyNameFor(Object value) {
            throw new InvalidUserDataException("Cannot query incremental changes for property " + value + ": Requires using 'InputChanges'.");
        }

        @Override
        public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return InputFileChanges.EMPTY;
        }

        @Override
        public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return new DefaultInputFileChanges(previous, current);
        }
    };

    public String getPropertyNameFor(Object var1);

    public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> var1, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var2);

    public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> var1, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var2);
}

