/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Map;
import org.gradle.api.Describable;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DescriptiveChange;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

class InputValueChanges
implements ChangeContainer {
    private final Describable executable;
    private final ImmutableMap<String, String> changed;

    public InputValueChanges(ImmutableSortedMap<String, ValueSnapshot> previous, ImmutableSortedMap<String, ValueSnapshot> current, Describable executable) {
        ImmutableMap.Builder<String, String> changedBuilder = ImmutableMap.builder();
        for (Map.Entry entry : current.entrySet()) {
            String propertyName = (String)entry.getKey();
            ValueSnapshot currentSnapshot = (ValueSnapshot)entry.getValue();
            ValueSnapshot previousSnapshot = previous.get(propertyName);
            if (previousSnapshot == null || currentSnapshot.equals(previousSnapshot)) continue;
            changedBuilder.put(propertyName, currentSnapshot instanceof ImplementationSnapshot ? "Implementation" : "Value");
        }
        this.changed = changedBuilder.build();
        this.executable = executable;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        for (Map.Entry entry : this.changed.entrySet()) {
            String propertyName = (String)entry.getKey();
            String changeType = (String)entry.getValue();
            if (visitor.visitChange(new DescriptiveChange("%s of input property '%s' has changed for %s", changeType, propertyName, this.executable.getDisplayName()))) continue;
            return false;
        }
        return true;
    }
}

