/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class DefaultOutputFilesRepository
implements OutputFilesRepository,
Closeable {
    private final PersistentCache cacheAccess;
    private final PersistentIndexedCache<String, Boolean> outputFiles;

    public DefaultOutputFilesRepository(PersistentCache cacheAccess, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cacheAccess = cacheAccess;
        this.outputFiles = cacheAccess.createCache(DefaultOutputFilesRepository.cacheParameters(inMemoryCacheDecoratorFactory));
    }

    @Override
    public boolean isGeneratedByGradle(File file) {
        File absoluteFile = file.getAbsoluteFile();
        return this.containsFilesGeneratedByGradle(absoluteFile) || this.isContainedInAnOutput(absoluteFile);
    }

    private boolean isContainedInAnOutput(File absoluteFile) {
        for (File currentFile = absoluteFile; currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.outputFiles.getIfPresent(currentFile.getPath()) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilesGeneratedByGradle(File absoluteFile) {
        return this.outputFiles.getIfPresent(absoluteFile.getPath()) != null;
    }

    @Override
    public void recordOutputs(Iterable<? extends FileSystemSnapshot> outputSnapshots) {
        for (FileSystemSnapshot fileSystemSnapshot : outputSnapshots) {
            fileSystemSnapshot.accept(entrySnapshot -> {
                entrySnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                    @Override
                    public void visitDirectory(DirectorySnapshot directorySnapshot) {
                        this.recordOutputSnapshot(directorySnapshot);
                    }

                    @Override
                    public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                        this.recordOutputSnapshot(fileSnapshot);
                    }

                    private void recordOutputSnapshot(FileSystemLocationSnapshot snapshot) {
                        String outputPath = snapshot.getAbsolutePath();
                        File outputFile = new File(outputPath);
                        DefaultOutputFilesRepository.this.outputFiles.put(outputPath, Boolean.TRUE);
                        for (File outputFileParent = outputFile.getParentFile(); outputFileParent != null; outputFileParent = outputFileParent.getParentFile()) {
                            String parentPath = outputFileParent.getPath();
                            if (DefaultOutputFilesRepository.this.outputFiles.getIfPresent(parentPath) != null) break;
                            DefaultOutputFilesRepository.this.outputFiles.put(parentPath, Boolean.FALSE);
                        }
                    }
                });
                return SnapshotVisitResult.SKIP_SUBTREE;
            });
        }
    }

    private static PersistentIndexedCacheParameters<String, Boolean> cacheParameters(InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return PersistentIndexedCacheParameters.of("outputFiles", String.class, Boolean.class).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(100000, true));
    }

    @Override
    public void close() throws IOException {
        this.cacheAccess.close();
    }
}

