/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.IOException;
import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

public class FingerprintMapSerializer
extends AbstractSerializer<Map<String, FileSystemLocationFingerprint>> {
    private static final byte DEFAULT_NORMALIZATION = 1;
    private static final byte IGNORED_PATH_NORMALIZATION = 2;
    private static final byte DIR_FINGERPRINT = 1;
    private static final byte MISSING_FILE_FINGERPRINT = 2;
    private static final byte REGULAR_FILE_FINGERPRINT = 3;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();
    private final Interner<String> stringInterner;

    public FingerprintMapSerializer(Interner<String> stringInterner) {
        this.stringInterner = stringInterner;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> read(Decoder decoder) throws IOException {
        int fingerprintCount = decoder.readSmallInt();
        ImmutableMap.Builder<String, FileSystemLocationFingerprint> fingerprints = ImmutableMap.builderWithExpectedSize(fingerprintCount);
        for (int i = 0; i < fingerprintCount; ++i) {
            String absolutePath = this.stringInterner.intern(decoder.readString());
            FileSystemLocationFingerprint fingerprint = this.readFingerprint(decoder);
            fingerprints.put(absolutePath, fingerprint);
        }
        return fingerprints.build();
    }

    private FileSystemLocationFingerprint readFingerprint(Decoder decoder) throws IOException {
        FileType fileType = this.readFileType(decoder);
        HashCode contentHash = this.readContentHash(fileType, decoder);
        byte fingerprintKind = decoder.readByte();
        switch (fingerprintKind) {
            case 1: {
                String normalizedPath = decoder.readString();
                return new DefaultFileSystemLocationFingerprint(this.stringInterner.intern(normalizedPath), fileType, contentHash);
            }
            case 2: {
                return IgnoredPathFileSystemLocationFingerprint.create(fileType, contentHash);
            }
        }
        throw new RuntimeException("Unable to read serialized file fingerprint. Unrecognized value found in the data stream.");
    }

    private HashCode readContentHash(FileType fileType, Decoder decoder) throws IOException {
        switch (fileType) {
            case Directory: {
                return FileSystemLocationFingerprint.DIR_SIGNATURE;
            }
            case Missing: {
                return FileSystemLocationFingerprint.MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return this.hashCodeSerializer.read(decoder);
            }
        }
        throw new RuntimeException("Unable to read serialized file fingerprint. Unrecognized value found in the data stream.");
    }

    private FileType readFileType(Decoder decoder) throws IOException {
        byte fileKind = decoder.readByte();
        switch (fileKind) {
            case 1: {
                return FileType.Directory;
            }
            case 2: {
                return FileType.Missing;
            }
            case 3: {
                return FileType.RegularFile;
            }
        }
        throw new RuntimeException("Unable to read serialized file fingerprint. Unrecognized value found in the data stream.");
    }

    @Override
    public void write(Encoder encoder, Map<String, FileSystemLocationFingerprint> value) throws Exception {
        encoder.writeSmallInt(value.size());
        for (String key : value.keySet()) {
            encoder.writeString(key);
            FileSystemLocationFingerprint fingerprint = value.get(key);
            this.writeFingerprint(encoder, fingerprint);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FingerprintMapSerializer rhs = (FingerprintMapSerializer)obj;
        return Objects.equal(this.hashCodeSerializer, rhs.hashCodeSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.hashCodeSerializer);
    }

    private void writeFingerprint(Encoder encoder, FileSystemLocationFingerprint value) throws IOException {
        switch (value.getType()) {
            case Directory: {
                encoder.writeByte((byte)1);
                break;
            }
            case Missing: {
                encoder.writeByte((byte)2);
                break;
            }
            case RegularFile: {
                encoder.writeByte((byte)3);
                this.hashCodeSerializer.write(encoder, value.getNormalizedContentHash());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (value instanceof DefaultFileSystemLocationFingerprint) {
            encoder.writeByte((byte)1);
            encoder.writeString(value.getNormalizedPath());
        } else if (value instanceof IgnoredPathFileSystemLocationFingerprint) {
            encoder.writeByte((byte)2);
        } else {
            throw new AssertionError();
        }
    }
}

