/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class DefaultInputFingerprinter
implements InputFingerprinter {
    private final ValueSnapshotter valueSnapshotter;

    public DefaultInputFingerprinter(ValueSnapshotter valueSnapshotter) {
        this.valueSnapshotter = valueSnapshotter;
    }

    @Override
    public InputFingerprinter.Result fingerprintInputProperties(UnitOfWork work, ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints, InputFingerprinter.InputPropertyPredicate filter) {
        InputCollectingVisitor visitor = new InputCollectingVisitor(work, previousValueSnapshots, this.valueSnapshotter, knownValueSnapshots, knownFingerprints, filter);
        work.visitInputs(visitor);
        return visitor.complete();
    }

    @VisibleForTesting
    public static class InputFingerprints
    implements InputFingerprinter.Result {
        private final ImmutableSortedMap<String, ValueSnapshot> valueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints;

        public InputFingerprints(ImmutableSortedMap<String, ValueSnapshot> valueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints) {
            this.valueSnapshots = valueSnapshots;
            this.fileFingerprints = fileFingerprints;
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots() {
            return this.valueSnapshots;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints() {
            return this.fileFingerprints;
        }
    }

    private static class InputCollectingVisitor
    implements UnitOfWork.InputVisitor {
        private final UnitOfWork work;
        private final ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots;
        private final ValueSnapshotter valueSnapshotter;
        private final ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints;
        private final InputFingerprinter.InputPropertyPredicate filter;
        private final ImmutableSortedMap.Builder<String, ValueSnapshot> valueSnapshotsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> fingerprintsBuilder = ImmutableSortedMap.naturalOrder();

        public InputCollectingVisitor(UnitOfWork work, ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFingerprints, InputFingerprinter.InputPropertyPredicate filter) {
            this.work = work;
            this.previousValueSnapshots = previousValueSnapshots;
            this.valueSnapshotter = valueSnapshotter;
            this.knownValueSnapshots = knownValueSnapshots;
            this.knownFingerprints = knownFingerprints;
            this.filter = filter;
        }

        @Override
        public void visitInputProperty(String propertyName, UnitOfWork.IdentityKind identity, UnitOfWork.ValueSupplier value) {
            if (this.knownValueSnapshots.containsKey(propertyName)) {
                return;
            }
            if (!this.filter.include(propertyName, UnitOfWork.InputPropertyType.NON_INCREMENTAL, identity)) {
                return;
            }
            Object actualValue = value.getValue();
            try {
                ValueSnapshot previousSnapshot = this.previousValueSnapshots.get(propertyName);
                if (previousSnapshot == null) {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue));
                } else {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", this.work.getDisplayName(), propertyName, value.getValue()), e);
            }
        }

        @Override
        public void visitInputFileProperty(String propertyName, UnitOfWork.InputPropertyType type, UnitOfWork.IdentityKind identity, @Nullable Object value, Supplier<CurrentFileCollectionFingerprint> fingerprinter) {
            if (this.knownFingerprints.containsKey(propertyName)) {
                return;
            }
            if (!this.filter.include(propertyName, type, identity)) {
                return;
            }
            this.fingerprintsBuilder.put((Object)propertyName, (Object)fingerprinter.get());
        }

        public InputFingerprinter.Result complete() {
            return new InputFingerprints((ImmutableSortedMap<String, ValueSnapshot>)this.valueSnapshotsBuilder.build(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.fingerprintsBuilder.build());
        }
    }
}

